/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.helper;

import dalapo.factech.helper.FacArrayHelper;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class FacStackHelper {
    private FacStackHelper() {
    }

    public static boolean isItemDamageNonZero(ItemStack is) {
        return is.func_77952_i() != 0;
    }

    public static boolean areAllEmpty(ItemStack[] test) {
        for (int i = 0; i < test.length; ++i) {
            if (test[i].func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static boolean matchStackArray(ItemStack[] a, ItemStack[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].func_77969_a(b[i])) continue;
            return false;
        }
        return true;
    }

    public static int matchAny(boolean ignoreDamage, ItemStack test, ItemStack ... arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (!(ignoreDamage ? test.func_77973_b().equals(arr[i].func_77973_b()) : test.func_77969_a(arr[i]))) continue;
            return i;
        }
        return -1;
    }

    public static boolean matchAll(ItemStack test, ItemStack ... arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (FacStackHelper.areItemsEqualAllowEmpty(test, arr[i], false)) continue;
            return false;
        }
        return true;
    }

    public static int getRemainingDurability(ItemStack toolIn) {
        return toolIn.func_77958_k() - toolIn.func_77952_i();
    }

    public static boolean matchStacks(ItemStack a, Item item, int damage) {
        return a.func_77973_b().equals(item) && a.func_77952_i() == damage;
    }

    public static boolean matchStacksWithWildcard(ItemStack a, ItemStack b) {
        return FacStackHelper.matchStacksWithWildcard(a, b, false);
    }

    public static boolean matchStacksWithWildcard(ItemStack a, ItemStack b, boolean oreDict) {
        if (a.func_77969_a(b)) {
            return true;
        }
        return a.func_77973_b().equals(b.func_77973_b()) && (a.func_77952_i() == Short.MAX_VALUE || b.func_77952_i() == Short.MAX_VALUE) || oreDict && FacStackHelper.matchOreDict(a, b);
    }

    public static boolean matchOreDict(ItemStack a, ItemStack b) {
        if (a.func_190926_b() || b.func_190926_b()) {
            return false;
        }
        try {
            return FacArrayHelper.matchAnyIgnoreIndex(OreDictionary.getOreIDs((ItemStack)a), OreDictionary.getOreIDs((ItemStack)b));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean areItemsEqualAllowEmpty(@Nonnull ItemStack a, @Nonnull ItemStack b, boolean wildcard) {
        if (a.func_190926_b() && b.func_190926_b()) {
            return true;
        }
        return wildcard ? FacStackHelper.matchStacksWithWildcard(a, b) : a.func_77969_a(b);
    }

    public static boolean areItemStacksIdentical(@Nonnull ItemStack a, @Nonnull ItemStack b, boolean wildcard) {
        return FacStackHelper.areItemsEqualAllowEmpty(a, b, wildcard) && a.func_190916_E() == b.func_190916_E();
    }

    public static boolean areItemStacksIdentical(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        return FacStackHelper.areItemsEqualAllowEmpty(a, b, false) && a.func_190916_E() == b.func_190916_E();
    }

    public static boolean areFluidStacksIdentical(FluidStack a, FluidStack b) {
        if (a == null || b == null) {
            return a == null && b == null;
        }
        return a.getFluid() == b.getFluid() && a.amount == b.amount;
    }

    public static boolean areFluidStacksEqual(@Nullable FluidStack a, @Nullable FluidStack b) {
        if (a == null && b == null) {
            return true;
        }
        return a.getFluid() == b.getFluid();
    }

    public static boolean canCombineStacks(ItemStack a, ItemStack b) {
        if (a.func_190926_b() || b.func_190926_b()) {
            return true;
        }
        return a.func_77969_a(b) && a.func_190916_E() + b.func_190916_E() <= a.func_77976_d();
    }

    @Nonnull
    public static ItemStack findStack(IInventory inv, Predicate<ItemStack> p, boolean consume) {
        boolean found = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!p.test(inv.func_70301_a(i))) continue;
            ItemStack temp = inv.func_70301_a(i).func_77946_l();
            if (consume) {
                inv.func_70298_a(i, 1);
            }
            return temp;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack findStack(IItemHandler inv, Predicate<ItemStack> p, boolean consume) {
        boolean found = false;
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!p.test(inv.getStackInSlot(i))) continue;
            ItemStack temp = inv.extractItem(i, 1, !consume);
            return temp;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean canCombineFluids(FluidStack a, FluidStack b) {
        if (a == null || b == null) {
            return true;
        }
        return a.getFluid().equals(b.getFluid());
    }

    public static void spawnEntityItem(World world, ItemStack stack, double x, double y, double z, boolean freeze) {
        EntityItem ei = new EntityItem(world, x, y, z, stack);
        if (freeze) {
            ei.field_70159_w = 0.0;
            ei.field_70181_x = 0.0;
            ei.field_70179_y = 0.0;
        }
        world.func_72838_d((Entity)ei);
    }

    public static void spawnEntityItem(World world, ItemStack stack, BlockPos pos, boolean freeze) {
        FacStackHelper.spawnEntityItem(world, stack, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, freeze);
    }

    public static String describeFluidStack(FluidStack fs) {
        return String.format("%sx %s", fs.amount, fs.getUnlocalizedName());
    }
}

