/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.helper;

import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.Pair;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FacTileHelper {
    private FacTileHelper() {
    }

    public static Pair<EnumFacing, TileEntity> getFirstAdjacentTile(BlockPos pos, World world, Capability capability) {
        for (int i = 0; i < 6; ++i) {
            BlockPos offset = FacMathHelper.withOffset(pos, EnumFacing.func_82600_a((int)i));
            TileEntity te = world.func_175625_s(offset);
            if (te == null || capability != null && !te.hasCapability(capability, EnumFacing.func_82600_a((int)i).func_176734_d())) continue;
            return new Pair<EnumFacing, TileEntity>(EnumFacing.func_82600_a((int)i), te);
        }
        return null;
    }

    public static Pair<EnumFacing, TileEntity> getFirstAdjacentTile(BlockPos pos, World world, Class<? extends TileEntity> type) {
        for (int i = 0; i < 6; ++i) {
            BlockPos offset = FacMathHelper.withOffset(pos, EnumFacing.func_82600_a((int)i));
            TileEntity te = world.func_175625_s(offset);
            if (te == null || !type.isAssignableFrom(te.getClass())) continue;
            return new Pair<EnumFacing, TileEntity>(EnumFacing.func_82600_a((int)i), te);
        }
        return null;
    }

    public static boolean isValidSlotForSide(IItemHandler inv, EnumFacing side, int slot, boolean extract) {
        return FacTileHelper.isValidSlotForSide(inv, side.ordinal(), slot, extract);
    }

    public static boolean isValidSlotForSide(IItemHandler inv, int side, int slot, boolean extract) {
        return !inv.extractItem(slot, 1, true).func_190926_b();
    }

    public static boolean hasSpaceForItem(IItemHandler inv, ItemStack is, int side, boolean def) {
        if (inv == null) {
            return def;
        }
        return FacTileHelper.tryInsertItem(inv, is, side, true).func_190926_b();
    }

    public static boolean hasSpaceForItem(IItemHandler inv, ItemStack is, EnumFacing side, boolean def) {
        return FacTileHelper.hasSpaceForItem(inv, is, side.ordinal(), def);
    }

    public static ItemStack getFirstItem(IItemHandler inv, int side, boolean extract) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!FacTileHelper.isValidSlotForSide(inv, side, i, extract) || inv.getStackInSlot(i) == null) continue;
            return inv.getStackInSlot(i);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack tryInsertItem(TileEntity te, ItemStack itemstack, int side, boolean simulate) {
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.func_82600_a((int)side))) {
            return FacTileHelper.tryInsertItem((IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.func_82600_a((int)side)), itemstack, side, simulate);
        }
        return itemstack;
    }

    public static ItemStack tryInsertItem(IItemHandler inv, ItemStack itemstack, int side) {
        return FacTileHelper.tryInsertItem(inv, itemstack, side, false);
    }

    public static ItemStack tryInsertItem(IItemHandler inv, ItemStack itemstack, int side, boolean simulate) {
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (inv == null) {
            return itemstack;
        }
        for (int i = 0; i < inv.getSlots() && !(itemstack = inv.insertItem(i, itemstack, simulate)).func_190926_b(); ++i) {
        }
        return itemstack;
    }

    public static int countItems(IItemHandler inventory, Predicate<ItemStack> criterion) {
        int acc = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack is = inventory.getStackInSlot(i);
            if (!criterion.test(is)) continue;
            acc += is.func_190916_E();
        }
        return acc;
    }

    public static int countItems(IItemHandler inventory, Item item, int dmg) {
        return FacTileHelper.countItems(inventory, stack -> stack.func_77973_b() == item && (dmg == Short.MAX_VALUE || stack.func_77952_i() == dmg));
    }
}

