/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.helper;

import dalapo.factech.gui.ContainerBasicMachine;
import dalapo.factech.gui.GuiAgitator;
import dalapo.factech.gui.GuiBasicMachine;
import dalapo.factech.gui.GuiCircuitScribe;
import dalapo.factech.gui.GuiFacInventory;
import dalapo.factech.gui.GuiFluidDrill;
import dalapo.factech.gui.GuiFluidMachine;
import dalapo.factech.gui.GuiSluice;
import dalapo.factech.gui.GuiStabilizer;
import dalapo.factech.gui.GuiTemperer;
import dalapo.factech.helper.Pair;
import dalapo.factech.tileentity.TileEntityMachine;
import dalapo.factech.tileentity.specialized.TileEntityPropaneFurnace;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MachineContainerFactory {
    private MachineContainerFactory() {
    }

    public static ContainerBasicMachine getContainer(TileEntityMachine te, IInventory playerInv, String id) {
        ArrayList<Pair<Integer, Integer>> input = new ArrayList<Pair<Integer, Integer>>();
        ArrayList<Pair<Integer, Integer>> output = new ArrayList<Pair<Integer, Integer>>();
        int playerOffset = 0;
        switch (id) {
            case "centrifuge": 
            case "magcent": {
                input.add(new Pair<Integer, Integer>(35, 35));
                output.add(new Pair<Integer, Integer>(89, 17));
                output.add(new Pair<Integer, Integer>(89, 35));
                output.add(new Pair<Integer, Integer>(89, 53));
                break;
            }
            case "crucible": {
                input.add(new Pair<Integer, Integer>(80, 44));
                break;
            }
            case "woodcutter": {
                output.add(new Pair<Integer, Integer>(80, 35));
                break;
            }
            case "fluiddrill": 
            case "disruptor": 
            case "miner": 
            case "disassembler": 
            case "teslacoil": 
            case "iondisperser": 
            case "deepdrill": {
                break;
            }
            case "sluice": {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        output.add(new Pair<Integer, Integer>(71 + i * 18, 17 + j * 18));
                    }
                }
                break;
            }
            case "fridge": {
                output.add(new Pair<Integer, Integer>(98, 38));
                break;
            }
            case "drill": {
                input.add(new Pair<Integer, Integer>(80, 18));
                output.add(new Pair<Integer, Integer>(80, 55));
                break;
            }
            case "agitator": {
                input.add(new Pair<Integer, Integer>(52, 47));
                output.add(new Pair<Integer, Integer>(108, 47));
                break;
            }
            case "cchamber": {
                input.add(new Pair<Integer, Integer>(90, 8));
                output.add(new Pair<Integer, Integer>(90, 60));
                break;
            }
            case "electroplater": {
                input.add(new Pair<Integer, Integer>(62, 38));
                input.add(new Pair<Integer, Integer>(116, 13));
                output.add(new Pair<Integer, Integer>(116, 38));
                break;
            }
            case "potionmixer": {
                input.add(new Pair<Integer, Integer>(35, 44));
                input.add(new Pair<Integer, Integer>(27, 61));
                input.add(new Pair<Integer, Integer>(43, 61));
                output.add(new Pair<Integer, Integer>(89, 35));
                break;
            }
            case "propanefurnace": {
                input.add(new Pair<Integer, Integer>(98, 24));
                input.add(new Pair<Integer, Integer>(35, 53));
                output.add(new Pair<Integer, Integer>(98, 60));
                output.add(new Pair<Integer, Integer>(62, 65));
                break;
            }
            case "circuitscribe": {
                input.add(new Pair<Integer, Integer>(9, 29));
                output.add(new Pair<Integer, Integer>(9, 71));
                playerOffset = 34;
                break;
            }
            case "stabilizer": {
                input.add(new Pair<Integer, Integer>(80, 35));
                output.add(new Pair<Integer, Integer>(134, 35));
                break;
            }
            case "corecharger": 
            case "spawner": 
            case "planter": {
                input.add(new Pair<Integer, Integer>(80, 35));
                break;
            }
            case "temperer": {
                input.add(new Pair<Integer, Integer>(35, 35));
                output.add(new Pair<Integer, Integer>(116, 35));
                break;
            }
            default: {
                input.add(new Pair<Integer, Integer>(35, 35));
                output.add(new Pair<Integer, Integer>(89, 35));
            }
        }
        return new ContainerBasicMachine(te.countPartSlots(), playerOffset, te, playerInv, input.toArray(new Pair[0]), output.toArray(new Pair[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public static GuiFacInventory getGui(TileEntityMachine te, IInventory playerInv, String id) {
        switch (id) {
            case "sluice": {
                return new GuiSluice(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, te);
            }
            case "circuitscribe": {
                return new GuiCircuitScribe(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, te);
            }
            case "crucible": {
                GuiFluidMachine crucible = new GuiFluidMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, "crucible_gui", te){

                    @Override
                    protected void drawProgressBar() {
                        int progress = this.te.getProgressScaled(33);
                        this.func_73729_b(this.field_147003_i + 32, this.field_147009_r + 64 - progress, 198, 33 - progress, 4, progress);
                    }
                };
                crucible.setCoords(72, 61);
                crucible.setSize(32, 2);
                return crucible;
            }
            case "agitator": {
                return new GuiAgitator(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, te);
            }
            case "cchamber": {
                return new GuiFluidMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, "cchamber_gui", te){

                    @Override
                    protected void drawProgressBar() {
                        int progress = this.te.getProgressScaled(53);
                        this.func_73729_b(this.field_147003_i + 50, this.field_147009_r + 27, 197, 0, progress, 27);
                    }
                };
            }
            case "stabilizer": {
                return new GuiStabilizer(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, te);
            }
            case "temperer": {
                return new GuiTemperer(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, te);
            }
            case "saw": {
                return new GuiBasicMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, "saw_gui", te){

                    @Override
                    protected void drawProgressBar() {
                        int progress = this.te.getProgressScaled(21);
                        this.func_73729_b(this.field_147003_i + 34, this.field_147009_r + 16 + progress, 176, 137, 18, 18);
                    }
                };
            }
            case "drill": {
                return new GuiBasicMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, "drill_gui", te){

                    @Override
                    protected void drawProgressBar() {
                        int progress = this.te.getProgressScaled(49);
                        this.func_73729_b(this.field_147003_i + 66, this.field_147009_r + 19, 216, 50, 7, progress);
                        this.func_73729_b(this.field_147003_i + 103, this.field_147009_r + 19, 216, 50, 7, progress);
                    }
                };
            }
            case "fluiddrill": {
                return new GuiFluidDrill(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, te);
            }
            case "potionmixer": {
                return new GuiBasicMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, "potionmixer_gui", te){

                    @Override
                    public void drawProgressBar() {
                        int progress = this.te.getProgressScaled(46);
                        this.func_73729_b(this.field_147003_i + 22, this.field_147009_r + 78 - progress, 212, 65 - progress, 42, progress);
                    }
                };
            }
            case "miner": {
                return new GuiBasicMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, "autominer_gui", te){

                    @Override
                    public void drawProgressBar() {
                        if (this.te.getAge() > 0) {
                            int progress = this.te.getProgressScaled(50);
                            if (progress < 18) {
                                this.func_73729_b(this.field_147003_i + 58, this.field_147009_r + 46 - progress, 200, 2, 6, 7);
                            } else {
                                this.func_73729_b(this.field_147003_i + 39 + progress, this.field_147009_r + 29, 200, 2, 6, 7);
                            }
                        }
                    }
                };
            }
            case "centrifuge": {
                return new GuiBasicMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, "centrifuge_gui", te){

                    @Override
                    public void drawProgressBar() {
                        int progress = this.te.getProgressScaled(33);
                        this.func_73729_b(this.field_147003_i + 54, this.field_147009_r + 18, 197, 0, progress, 49);
                    }
                };
            }
            case "magcent": {
                return new GuiFluidMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, "magcent_gui", te){

                    @Override
                    public void drawProgressBar() {
                        int progress = this.te.getProgressScaled(33);
                        this.func_73729_b(this.field_147003_i + 54, this.field_147009_r + 18, 197, 0, progress, 49);
                    }
                }.setCoords(11, 64);
            }
            case "fridge": {
                return new GuiFluidMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, "fridge_gui", te){

                    @Override
                    public void drawProgressBar() {
                        int progress = this.te.getProgressScaled(44);
                        this.func_73729_b(this.field_147003_i + 50, this.field_147009_r + 32, 197, 0, progress, 27);
                    }
                };
            }
            case "propanefurnace": {
                return new GuiBasicMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, "propfurnace_gui", te){

                    @Override
                    public void drawProgressBar() {
                        int progress = this.te.getProgressScaled(13);
                        int propane = 5 * ((TileEntityPropaneFurnace)this.te).getPropane();
                        this.func_73729_b(this.field_147003_i + 99, this.field_147009_r + 44, 185, 47, 13, progress);
                        this.func_73729_b(this.field_147003_i + 15, this.field_147009_r + 81 - propane, 176, 47, 9, propane);
                    }
                };
            }
            case "electroplater": {
                return new GuiFluidMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, "electroplater_gui", te){

                    @Override
                    public void drawProgressBar() {
                        int progress = this.te.getProgressScaled(30);
                        this.func_73729_b(this.field_147003_i + 82, this.field_147009_r + 41, 176, 0, progress, 8);
                    }
                };
            }
            case "disruptor": 
            case "disassembler": 
            case "teslacoil": 
            case "iondisperser": 
            case "deepdrill": {
                return new GuiBasicMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, "gui_blank", te);
            }
            case "woodcutter": 
            case "corecharger": 
            case "spawner": 
            case "planter": {
                return new GuiBasicMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, "gui_single_slot", te);
            }
        }
        return new GuiBasicMachine(MachineContainerFactory.getContainer(te, playerInv, id), playerInv, te).setBarCoords(60, 37);
    }
}

