/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.init;

import dalapo.factech.block.fluid.BlockSulphuricAcid;
import dalapo.factech.block.fluid.FluidBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModFluidRegistry {
    public static List<FluidBase> fluids = new ArrayList<FluidBase>();
    public static FluidBase h2so4;
    public static FluidBase propane;
    public static FluidBase sulphur;
    public static FluidBase energite;
    public static FluidBase glowstone;
    public static FluidBase oreSlurry;
    public static BlockSulphuricAcid h2so4Block;

    public static void init() {
        h2so4 = (FluidBase)new FluidBase("h2so4").setDensity(1000);
        fluids.add(h2so4);
        propane = (FluidBase)new FluidBase("propane").setDensity(20);
        fluids.add(propane);
        sulphur = (FluidBase)new FluidBase("sulphur").setDensity(1500).setTemperature(400);
        fluids.add(sulphur);
        energite = (FluidBase)new FluidBase("energite").setDensity(100).setTemperature(350);
        fluids.add(energite);
        glowstone = (FluidBase)new FluidBase("ftglowstone").setDensity(0).setTemperature(500);
        fluids.add(glowstone);
        oreSlurry = (FluidBase)new FluidBase("ftoreslurry").setDensity(2000);
        fluids.add(oreSlurry);
        for (FluidBase f : fluids) {
            FluidRegistry.registerFluid((Fluid)f);
            FluidRegistry.addBucketForFluid((Fluid)f);
        }
        h2so4Block = new BlockSulphuricAcid(h2so4, (Material)new MaterialLiquid(MapColor.field_151670_w), "h2so4");
        h2so4.setBlock((Block)h2so4Block);
    }

    @SideOnly(value=Side.CLIENT)
    public static void initTextures(TextureStitchEvent.Pre evt) {
        TextureMap map = evt.getMap();
        ModFluidRegistry.registerFluidTexture(map, h2so4);
        ModFluidRegistry.registerFluidTexture(map, propane);
        ModFluidRegistry.registerFluidTexture(map, sulphur);
        ModFluidRegistry.registerFluidTexture(map, glowstone);
        ModFluidRegistry.registerFluidTexture(map, energite);
        h2so4Block.registerModel();
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidTexture(TextureMap map, FluidBase fluid) {
        map.func_174942_a(fluid.getStill());
        map.func_174942_a(fluid.getFlowing());
    }
}

