/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.item;

import dalapo.factech.init.TabRegistry;
import dalapo.factech.item.ItemModelProvider;
import java.util.List;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBase
extends Item
implements ItemModelProvider {
    protected final String name;
    private final int subtypes;
    protected boolean hasInformation;

    public ItemBase(String name, int subtypes) {
        this.name = name;
        this.subtypes = subtypes > 1 ? subtypes : 1;
        this.hasInformation = false;
        if (subtypes > 1) {
            this.field_77787_bX = true;
            this.func_77656_e(0);
        }
        this.func_77655_b("factorytech." + name);
        this.setRegistryName(name);
    }

    public ItemBase setHasInformation() {
        this.hasInformation = true;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack is, World world, List<String> list, ITooltipFlag flags) {
        if (this.hasInformation) {
            this.actuallyAddInformation(is, world, list, flags);
        }
    }

    protected void actuallyAddInformation(ItemStack is, World world, List<String> list, ITooltipFlag flags) {
    }

    public ItemBase(String name) {
        this(name, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (tab == TabRegistry.FACTECH) {
            for (int i = 0; i < this.subtypes; ++i) {
                subItems.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public int getSubtypeCount() {
        return this.subtypes;
    }

    public String func_77667_c(ItemStack stack) {
        if (this.field_77787_bX) {
            return "factorytech." + this.name + ":" + stack.func_77952_i();
        }
        return "factorytech." + this.name;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        if (this.field_77787_bX) {
            final ModelResourceLocation[] locations = new ModelResourceLocation[this.subtypes];
            for (int i = 0; i < this.subtypes; ++i) {
                locations[i] = new ModelResourceLocation(this.getRegistryName() + "_" + i, "inventory");
            }
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])locations);
            ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return locations[stack.func_77952_i()];
                }
            });
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }
}

