/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.item;

import dalapo.factech.FactoryTech;
import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.Logger;
import dalapo.factech.item.ItemBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHandPump
extends ItemBase {
    public ItemHandPump(String name) {
        super(name);
        this.func_77625_d(1);
        this.setHasInformation();
        this.canRepair = false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void actuallyAddInformation(ItemStack is, World world, List<String> list, ITooltipFlag flags) {
        if (!is.func_77942_o() || is.func_77978_p().func_74762_e("charges") == 0) {
            list.add("Empty");
        } else {
            list.add(String.format("Buckets stored: %s / 8", is.func_77978_p().func_74762_e("charges")));
            if (is.func_77978_p().func_74779_i("liquid").startsWith("universal:")) {
                Fluid fluid = FluidRegistry.getFluid((String)is.func_77978_p().func_74779_i("liquid").substring(10));
                list.add(String.format("Liquid: %s", fluid.getLocalizedName(null)));
            } else {
                list.add(String.format("Liquid: %s", ((Block)FactoryTech.BLOCK_REGISTRY.getValue(new ResourceLocation(is.func_77978_p().func_74779_i("liquid").substring(10)))).func_149732_F()));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer ep, EnumHand hand) {
        super.func_77659_a(world, ep, hand);
        ItemStack is = ep.func_184586_b(hand);
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
            is.func_77978_p().func_74768_a("charges", 0);
        }
        NBTTagCompound nbt = is.func_77978_p();
        int charges = nbt.func_74762_e("charges");
        RayTraceResult raytrace = this.func_77621_a(world, ep, true);
        if (raytrace == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)is);
        }
        BlockPos target = raytrace.func_178782_a();
        if (world.func_180495_p(target).func_177230_c() instanceof BlockLiquid) {
            BlockLiquid block = (BlockLiquid)FacBlockHelper.getBlock(world, target);
            if (!(charges >= 8 || is.func_77978_p().func_74764_b("liquid") && block != FactoryTech.BLOCK_REGISTRY.getValue(new ResourceLocation(nbt.func_74779_i("liquid"))))) {
                world.func_175698_g(target);
                nbt.func_74768_a("charges", charges + 1);
                nbt.func_74778_a("liquid", block.getRegistryName().toString());
                return new ActionResult(EnumActionResult.SUCCESS, (Object)is);
            }
        } else if (world.func_180495_p(target).func_177230_c() instanceof IFluidBlock) {
            IFluidBlock block = (IFluidBlock)FacBlockHelper.getBlock(world, target);
            if (charges < 8 && (!is.func_77978_p().func_74764_b("liquid") || is.func_77978_p().func_74779_i("liquid").substring(10).equals(block.getFluid().getName()))) {
                world.func_175698_g(target);
                nbt.func_74768_a("charges", charges + 1);
                nbt.func_74778_a("liquid", "universal:" + block.getFluid().getName());
                return new ActionResult(EnumActionResult.SUCCESS, (Object)is);
            }
        } else if (charges >= 1) {
            BlockPos toPlace = FacMathHelper.withOffset(target, raytrace.field_178784_b);
            String str = nbt.func_74779_i("liquid");
            boolean success = false;
            if (str.startsWith("universal:")) {
                Logger.info(str);
                IFluidBlock block = (IFluidBlock)FluidRegistry.getFluid((String)str.substring(10)).getBlock();
                FluidStack dummy = new FluidStack(FluidRegistry.getFluid((String)str.substring(10)), 1000);
                success = true;
                block.place(world, toPlace, dummy, true);
            } else {
                BlockLiquid liquidToPlace = (BlockLiquid)FactoryTech.BLOCK_REGISTRY.getValue(new ResourceLocation(nbt.func_74779_i("liquid")));
                world.func_175656_a(toPlace, BlockLiquid.func_176361_a((Material)liquidToPlace.func_149688_o(liquidToPlace.func_176223_P())).func_176223_P());
                success = true;
            }
            if (success) {
                if (charges == 1) {
                    nbt.func_82580_o("liquid");
                }
                nbt.func_74768_a("charges", charges - 1);
                world.func_175684_a(target, world.func_180495_p(target).func_177230_c(), 1);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)is);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)is);
    }
}

