/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.item;

import dalapo.factech.entity.EntityPressureGunShot;
import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.init.ItemRegistry;
import dalapo.factech.item.ItemBase;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemPressureGun
extends ItemBase {
    public ItemPressureGun(String name) {
        super(name);
        this.func_77656_e(301);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    private int getTankID(ItemStack is) {
        if (!is.func_77942_o()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("tank", -1);
            is.func_77982_d(nbt);
        }
        return is.func_77978_p().func_74762_e("tank");
    }

    @Override
    protected void actuallyAddInformation(ItemStack is, World world, List<String> list, ITooltipFlag flags) {
        int tank = this.getTankID(is);
        String str = "Active fluid: ";
        switch (tank) {
            case -1: {
                str = str + "None";
                break;
            }
            case 0: {
                str = str + "Air";
                break;
            }
            case 1: {
                str = str + "Water";
                break;
            }
            case 2: {
                str = str + "Propane";
                break;
            }
            case 3: {
                str = str + "H2SO4";
                break;
            }
            case 4: {
                str = str + "Sulphur";
                break;
            }
            case 5: {
                str = str + "Glowstone";
                break;
            }
            case 6: {
                str = str + "Energite";
            }
        }
        list.add(str);
    }

    public int func_77626_a(ItemStack is) {
        return 20;
    }

    public void func_77615_a(ItemStack is, World world, EntityLivingBase ep, int count) {
        super.func_77615_a(is, world, ep, count);
    }

    public void onUsingTick(ItemStack is, EntityLivingBase ep, int count) {
        super.onUsingTick(is, ep, count);
        if (this.getTankID(is) == -1) {
            return;
        }
        if (is.func_77952_i() < 300) {
            int tank = this.getTankID(ep.func_184614_ca());
            int shots = 1;
            if (tank == 0 || tank == 2) {
                shots = 5;
            }
            is.func_77964_b(is.func_77952_i() + 1);
            for (int i = 0; i < shots; ++i) {
                EntityPressureGunShot shot = new EntityPressureGunShot(ep.field_70170_p, ep, tank, this.isFreshestWeapon(is));
                Vec3d lookDir = ep.func_70040_Z();
                double spread = shot.getProjType().spread;
                Vec3d motionVec = lookDir.func_72441_c(ep.func_70681_au().nextGaussian() * spread, ep.func_70681_au().nextGaussian() * spread, ep.func_70681_au().nextGaussian() * spread);
                shot.field_70159_w = motionVec.field_72450_a;
                shot.field_70181_x = motionVec.field_72448_b;
                shot.field_70179_y = motionVec.field_72449_c;
                ep.field_70170_p.func_72838_d((Entity)shot);
            }
        }
        if (is.func_77952_i() == 300) {
            is.func_77964_b(0);
            ItemStack tank = new ItemStack((Item)ItemRegistry.tank, 1, 0);
            ep.field_70170_p.func_72838_d((Entity)new EntityItem(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, tank));
            is.func_77978_p().func_74768_a("tank", -1);
        }
    }

    private boolean isFreshestWeapon(ItemStack is) {
        return is.func_82833_r().equals("Splattershot");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer ep, EnumHand hand) {
        ItemStack is = ep.func_184586_b(hand);
        int tankNum = this.getTankID(is);
        if (tankNum == -1) {
            super.func_77659_a(world, ep, hand);
            ItemStack tank = FacStackHelper.findStack((IInventory)ep.field_71071_by, itemstack -> itemstack.func_77952_i() != 0 && itemstack.func_77973_b() == ItemRegistry.tank, !ep.func_184812_l_());
            if (tank.func_190926_b()) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)is);
            }
            tankNum = tank.func_77952_i() - 1;
            is.func_77978_p().func_74768_a("tank", tankNum);
            is.func_77964_b(0);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)is);
        }
        ep.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)is);
    }
}

