/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.item;

import dalapo.factech.item.ItemBase;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ItemUniversalTank
extends ItemBase {
    public ItemUniversalTank(String name) {
        super("universaltank");
    }

    public ICapabilityProvider initCapabilities(ItemStack is, NBTTagCompound nbt) {
        if (!is.func_77942_o() || nbt == null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("fluid", "<empty>");
            is.func_77982_d(tag);
        } else {
            is.func_77982_d(nbt);
        }
        return new UniversalTankCapability(is);
    }

    private static class UniversalTankCapability
    implements IFluidHandlerItem,
    ICapabilityProvider {
        @Nullable
        Fluid fluid;
        ItemStack container;

        UniversalTankCapability(ItemStack is) {
            this(is, null);
        }

        UniversalTankCapability(ItemStack is, NBTTagCompound nbt) {
            this.fluid = nbt == null ? null : FluidRegistry.getFluid((String)nbt.func_74779_i("fluid"));
            this.container = is;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this);
            }
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new FluidTankProperties[]{new FluidTankProperties(new FluidStack(this.fluid, 1000), 1000)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.fluid != null || resource.amount != 1000) {
                return 0;
            }
            if (doFill) {
                this.fluid = resource.getFluid();
                return 1000;
            }
            return 1000;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (this.fluid == null || resource.amount < 1000 || resource.getFluid() != this.fluid) {
                return null;
            }
            if (doDrain) {
                this.fluid = null;
            }
            return new FluidStack(resource.getFluid(), 1000);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain < 1000 || this.fluid == null) {
                return null;
            }
            FluidStack toReturn = new FluidStack(this.fluid, 1000);
            if (doDrain) {
                this.fluid = null;
            }
            return toReturn;
        }

        public ItemStack getContainer() {
            return this.container;
        }
    }
}

