/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.item;

import dalapo.factech.auxiliary.Linkable;
import dalapo.factech.auxiliary.Wrenchable;
import dalapo.factech.item.ItemBase;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemWrench
extends ItemBase {
    public static final String LINK_TAG = "link_pos";

    public ItemWrench(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        target.func_70097_a((DamageSource)new EntityDamageSource("melee", (Entity)attacker), 2.0f);
        return true;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack is = player.func_184586_b(hand);
        if (world.func_180495_p(pos).func_177230_c() instanceof Wrenchable) {
            ((Wrenchable)world.func_180495_p(pos).func_177230_c()).onWrenched(player, player.func_70093_af(), world, pos, side);
            return EnumActionResult.SUCCESS;
        }
        if (world.func_180495_p(pos).func_177230_c() instanceof Linkable) {
            if (!this.hasLink(is)) {
                this.setLink(is, pos);
            } else {
                ((Linkable)world.func_180495_p(pos).func_177230_c()).onLinked(world, player, pos, this.getLink(is), is);
                this.clearLink(is);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean hasLink(ItemStack wrench) {
        return wrench.func_77942_o() && wrench.func_77978_p().func_74764_b(LINK_TAG);
    }

    @Nullable
    public BlockPos getLink(ItemStack wrench) {
        return this.hasLink(wrench) ? BlockPos.func_177969_a((long)wrench.func_77978_p().func_74763_f(LINK_TAG)) : null;
    }

    public void setLink(ItemStack wrench, BlockPos link) {
        if (!wrench.func_77942_o()) {
            wrench.func_77982_d(new NBTTagCompound());
        }
        wrench.func_77978_p().func_74772_a(LINK_TAG, link.func_177986_g());
    }

    public void clearLink(ItemStack wrench) {
        if (this.hasLink(wrench)) {
            wrench.func_77978_p().func_82580_o(LINK_TAG);
        }
    }
}

