/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.packet;

import dalapo.factech.auxiliary.IHasFluid;
import dalapo.factech.packet.FacTechPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class FluidInfoPacket
extends FacTechPacket {
    FluidStack[] fluids;
    BlockPos pos;

    public FluidInfoPacket() {
    }

    public FluidInfoPacket(BlockPos pos, FluidTank[] tanks, int num) {
        this.pos = pos;
        this.fluids = new FluidStack[num];
        for (int i = 0; i < num; ++i) {
            this.fluids[i] = tanks[i].getFluid();
        }
    }

    @Override
    protected void actuallyDoHandle(FacTechPacket msg, World world, EntityPlayer ep, boolean isClient) {
        if (isClient) {
            IHasFluid te = (IHasFluid)world.func_175625_s(this.pos);
            for (int i = 0; i < ((FluidInfoPacket)msg).fluids.length; ++i) {
                te.overrideTank(((FluidInfoPacket)msg).fluids[i], i);
            }
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.fluids = new FluidStack[buf.readInt()];
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        for (int i = 0; i < this.fluids.length; ++i) {
            int length = buf.readInt();
            if (length == -1) {
                this.fluids[i] = null;
                continue;
            }
            byte[] arr = new byte[length];
            for (int j = 0; j < length; ++j) {
                arr[j] = buf.readByte();
            }
            String str = new String(arr);
            this.fluids[i] = new FluidStack(FluidRegistry.getFluid((String)str), buf.readInt());
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.fluids.length);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        for (int i = 0; i < this.fluids.length; ++i) {
            if (this.fluids[i] == null) {
                buf.writeInt(-1);
                continue;
            }
            buf.writeInt(this.fluids[i].getFluid().getName().length());
            buf.writeBytes(this.fluids[i].getFluid().getName().getBytes());
            buf.writeInt(this.fluids[i].amount);
        }
    }
}

