/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.packet;

import dalapo.factech.helper.FacChatHelper;
import dalapo.factech.helper.Logger;
import dalapo.factech.packet.FacTechPacket;
import dalapo.factech.packet.PacketHandler;
import dalapo.factech.tileentity.automation.TileEntityItemRedis;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemRedisPacket
extends FacTechPacket {
    BlockPos pos;
    int[] vals = new int[5];
    int side;
    int change;
    boolean toggle;

    @Override
    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        for (int i = 0; i < 5; ++i) {
            this.vals[i] = buf.readInt();
        }
        this.side = buf.readInt();
        this.change = buf.readInt();
        this.toggle = buf.readBoolean();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        for (int i : this.vals) {
            buf.writeInt(i);
        }
        buf.writeInt(this.side);
        buf.writeInt(this.change);
        buf.writeBoolean(this.toggle);
    }

    public ItemRedisPacket(TileEntityItemRedis te, int s, int c, boolean toggle) {
        this.handler = new FacTechPacket.Handler();
        this.pos = te.func_174877_v();
        this.side = s;
        this.change = c;
        this.toggle = toggle;
    }

    public ItemRedisPacket() {
    }

    @Override
    protected void actuallyDoHandle(FacTechPacket message, World world, EntityPlayer ep, boolean isToClient) {
        if (!isToClient) {
            TileEntityItemRedis te = (TileEntityItemRedis)world.func_175625_s(((ItemRedisPacket)message).pos);
            if (!(te instanceof TileEntityItemRedis)) {
                throw new RuntimeException("Minecraft updates broke the server!");
            }
            te.changeRatio(((ItemRedisPacket)message).side, ((ItemRedisPacket)message).change);
            if (((ItemRedisPacket)message).toggle) {
                te.toggleSplit();
            }
            te.func_70296_d();
            for (int i = 0; i < 5; ++i) {
                this.vals[i] = te.getRatio(i);
            }
            ((ItemRedisPacket)message).toggle = te.shouldSplit();
            PacketHandler.sendToPlayer(message, (EntityPlayer)((EntityPlayerMP)ep));
        } else {
            TileEntityItemRedis te = (TileEntityItemRedis)world.func_175625_s(((ItemRedisPacket)message).pos);
            if (!(te instanceof TileEntityItemRedis)) {
                throw new RuntimeException("Minecraft updates broke the client!");
            }
            for (int i = 0; i < 5; ++i) {
                te.setRatio(i, this.vals[i]);
                Logger.info(this.vals[i]);
            }
            if (((ItemRedisPacket)message).change == 0) {
                FacChatHelper.sendMessage(this.toggle ? "Now splitting stacks" : "Now keeping stacks together");
            }
            te.func_70296_d();
        }
    }

    public int getID() {
        return 1;
    }
}

