/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.packet;

import dalapo.factech.packet.FacTechPacket;
import dalapo.factech.tileentity.specialized.TileEntityStabilizer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StabilizerPacket
extends FacTechPacket {
    BlockPos pos;
    short stability;
    short[] strength = new short[4];
    boolean[] cooling = new boolean[4];

    public StabilizerPacket(TileEntityStabilizer te) {
        this.pos = te.func_174877_v();
        this.stability = te.getStability();
        for (int i = 0; i < 4; ++i) {
            this.strength[i] = te.getStrength(i);
            this.cooling[i] = te.isCooling(i);
        }
    }

    public StabilizerPacket() {
    }

    @Override
    protected void actuallyDoHandle(FacTechPacket msg, World world, EntityPlayer ep, boolean isClient) {
        TileEntity te = world.func_175625_s(((StabilizerPacket)msg).pos);
        if (te instanceof TileEntityStabilizer) {
            ((TileEntityStabilizer)te).updateValues(((StabilizerPacket)msg).stability, ((StabilizerPacket)msg).strength, ((StabilizerPacket)msg).cooling);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.stability = buf.readShort();
        for (int i = 0; i < 4; ++i) {
            this.strength[i] = buf.readShort();
            this.cooling[i] = buf.readBoolean();
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeShort((int)this.stability);
        for (int i = 0; i < 4; ++i) {
            buf.writeShort((int)this.strength[i]);
            buf.writeBoolean(this.cooling[i]);
        }
    }
}

