/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.helper.FacCraftTweakerHelper;
import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.plugins.crafttweaker.ScheduledRemovals;
import dalapo.factech.tileentity.specialized.TileEntityAgitator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorytech.Agitator")
@ZenRegister
public class Agitator {
    @ZenMethod
    public static void addRecipe(IIngredient fluid1, @Optional IIngredient fluid2, @Optional IIngredient itemIn, @Optional IIngredient fluidOut, @Optional IIngredient itemOut) {
        CraftTweakerAPI.apply((IAction)new Add(FacCraftTweakerHelper.toStack((ILiquidStack)fluid1), FacCraftTweakerHelper.toStack((ILiquidStack)fluid2), FacCraftTweakerHelper.toStack((IItemStack)itemIn), FacCraftTweakerHelper.toStack((ILiquidStack)fluidOut), FacCraftTweakerHelper.toStack((IItemStack)itemOut)));
    }

    @ZenMethod
    public static void removeRecipe(@Optional IItemStack item, @Optional ILiquidStack fluid) {
        CraftTweakerAPI.apply((IAction)new Remove(FacCraftTweakerHelper.toStack(fluid), FacCraftTweakerHelper.toStack(item)));
    }

    private static class Remove
    implements IAction {
        FluidStack fluidOut;
        ItemStack itemOut;

        public Remove(FluidStack fs, ItemStack is) {
            this.fluidOut = fs;
            this.itemOut = is;
        }

        public void apply() {
            for (int i = MachineRecipes.AGITATOR.size() - 1; i >= 0; --i) {
                TileEntityAgitator.AgitatorRecipe r = MachineRecipes.AGITATOR.get(i);
                if (!FacStackHelper.areFluidStacksIdentical(r.getOutputFluid(), this.fluidOut) || !FacStackHelper.areItemStacksIdentical(r.getOutputItem(), this.itemOut)) continue;
                ScheduledRemovals.INSTANCE.scheduleRemoval(MachineRecipes.AGITATOR, i);
            }
        }

        public String describe() {
            return "Removing Agitator recipe";
        }
    }

    private static class Add
    implements IAction {
        private TileEntityAgitator.AgitatorRecipe recipe;

        public Add(FluidStack fluid1, FluidStack fluid2, ItemStack item1, FluidStack fluidOut, ItemStack itemOut) {
            this.recipe = new TileEntityAgitator.AgitatorRecipe(item1, itemOut, fluidOut, fluid1, fluid2);
        }

        public void apply() {
            MachineRecipes.AGITATOR.add(this.recipe);
        }

        public String describe() {
            return "Adding Agitator recipe";
        }
    }
}

