/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.helper.FacCraftTweakerHelper;
import dalapo.factech.plugins.crafttweaker.ScheduledAdditions;
import dalapo.factech.plugins.crafttweaker.ScheduledRemovals;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorytech.Centrifuge")
@ZenRegister
public class Centrifuge {
    @ZenMethod
    public static void addRecipe(IIngredient input, IItemStack output1, @Optional IItemStack output2, @Optional IItemStack output3, @Optional boolean worksWithBad) {
        for (IItemStack in : input.getItems()) {
            CraftTweakerAPI.apply((IAction)new Add((ItemStack)in.getInternal(), FacCraftTweakerHelper.toStacks(output1, output2, output3), worksWithBad));
        }
    }

    @ZenMethod
    public static void removeRecipe(IItemStack ... output) {
        CraftTweakerAPI.apply((IAction)new Remove(FacCraftTweakerHelper.toStacks(output)));
    }

    private static class Remove
    implements IAction {
        ItemStack[] output;

        public Remove(ItemStack[] o) {
            this.output = o;
        }

        public void apply() {
            for (int i = MachineRecipes.CENTRIFUGE.size() - 1; i >= 0; --i) {
                MachineRecipes.MachineRecipe<ItemStack, ItemStack[]> recipe = MachineRecipes.CENTRIFUGE.get(i);
                if (this.output.length != recipe.output().length) continue;
                boolean flag = true;
                for (int j = 0; j < this.output.length; ++j) {
                    if (this.output[j].func_77969_a(recipe.output()[j])) continue;
                    flag = false;
                }
                if (!flag) continue;
                ScheduledRemovals.INSTANCE.scheduleRemoval(MachineRecipes.CENTRIFUGE, i);
            }
        }

        public String describe() {
            return "Removing Centrifuge recipe for " + this.output;
        }
    }

    private static class Add
    implements IAction {
        private ItemStack in;
        private ItemStack[] out;
        private boolean worksWithBad;

        public Add(ItemStack in, ItemStack[] out, boolean worksWithBad) {
            this.in = in;
            this.out = out;
        }

        public void apply() {
            if (this.out.length <= 3) {
                ScheduledAdditions.scheduleAddition(MachineRecipes.CENTRIFUGE, new MachineRecipes.MachineRecipe<ItemStack, ItemStack[]>(this.in, this.out, this.worksWithBad));
            }
        }

        public String describe() {
            return "Adding Centrifuge recipe for " + this.in + " -> " + this.out;
        }
    }
}

