/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.plugins.crafttweaker.ScheduledAdditions;
import dalapo.factech.plugins.crafttweaker.ScheduledRemovals;
import dalapo.factech.tileentity.specialized.TileEntityCompressionChamber;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorytech.CompressionChamber")
@ZenRegister
public class CompressionChamber {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, @Optional ILiquidStack fluidIn) {
        FluidStack fs = fluidIn == null ? null : (FluidStack)fluidIn.getInternal();
        for (IItemStack itemIn : input.getItems()) {
            CraftTweakerAPI.apply((IAction)new Add((ItemStack)itemIn.getInternal(), fs, (ItemStack)output.getInternal()));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        for (IItemStack out : output.getItems()) {
            CraftTweakerAPI.apply((IAction)new Remove((ItemStack)output.getInternal()));
        }
    }

    private static class Remove
    implements IAction {
        ItemStack output;

        public Remove(ItemStack o) {
            this.output = o;
        }

        public void apply() {
            ScheduledRemovals.INSTANCE.scheduleRemoval(MachineRecipes.COMPRESSOR, this.output);
        }

        public String describe() {
            return "Removing Refrigerator recipe for " + this.output;
        }
    }

    private static class Add
    implements IAction {
        private TileEntityCompressionChamber.CompressorRecipe recipe;

        public Add(ItemStack itemIn, FluidStack fluidIn, ItemStack out) {
            this.recipe = new TileEntityCompressionChamber.CompressorRecipe(itemIn, fluidIn, out);
        }

        public void apply() {
            ScheduledAdditions.scheduleAddition(MachineRecipes.COMPRESSOR, this.recipe);
        }

        public String describe() {
            return "Adding Compressor recipe: " + this.recipe.describe();
        }
    }
}

