/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.plugins.crafttweaker.MasterAdd;
import dalapo.factech.plugins.crafttweaker.ScheduledRemovals;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorytech.Crucible")
@ZenRegister
public class Crucible {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, IIngredient inputItem, boolean worksWithBad) {
        for (IItemStack input : inputItem.getItems()) {
            CraftTweakerAPI.apply((IAction)new Add((ItemStack)input.getInternal(), (FluidStack)output.getInternal(), false));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        for (ILiquidStack liquid : output.getLiquids()) {
            CraftTweakerAPI.apply((IAction)new Remove((FluidStack)output.getInternal()));
        }
    }

    private static class Remove
    implements IAction {
        FluidStack output;

        public Remove(FluidStack o) {
            this.output = o;
        }

        public void apply() {
            ScheduledRemovals.INSTANCE.scheduleRemoval(MachineRecipes.CRUCIBLE, this.output);
        }

        public String describe() {
            return "Removing Crucible recipe for " + this.output;
        }
    }

    private static class Add
    extends MasterAdd<ItemStack, FluidStack> {
        private ItemStack in;
        private FluidStack out;

        public Add(ItemStack in, FluidStack out, boolean worksWithBad) {
            super(in, out, worksWithBad, MachineRecipes.CRUCIBLE);
        }

        public String describe() {
            return "Adding Crucible recipe for " + this.in + " -> " + this.out;
        }
    }
}

