/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.helper.FacStackHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorytech.Disassembler")
@ZenRegister
public class Disassembler {
    @ZenMethod
    public static void addRecipe(String className, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Add(className, (ItemStack)output.getInternal()));
    }

    @ZenMethod
    public static void removeRecipe(String className, IIngredient output) {
        for (IItemStack out : output.getItems()) {
            CraftTweakerAPI.apply((IAction)new Remove(className, (ItemStack)out.getInternal()));
        }
    }

    private static class Remove
    implements IAction {
        String in;
        ItemStack output;

        public Remove(String in, ItemStack o) {
            this.output = o;
        }

        public void apply() {
            List<ItemStack> drops = MachineRecipes.DISASSEMBLER.get(this.in);
            for (int i = drops.size() - 1; i >= 0; --i) {
                if (!FacStackHelper.matchStacksWithWildcard(this.output, drops.get(i))) continue;
                drops.remove(i);
            }
        }

        public String describe() {
            return "Removing Disassembler recipe for " + this.output + " from " + this.in;
        }
    }

    private static class Add
    implements IAction {
        private String in;
        private ItemStack out;

        public Add(String in, ItemStack out) {
            this.in = in;
            this.out = out;
        }

        public void apply() {
            if (MachineRecipes.DISASSEMBLER.containsKey(this.in)) {
                MachineRecipes.DISASSEMBLER.get(this.in).add(this.out);
            } else {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                stacks.add(this.out);
                MachineRecipes.DISASSEMBLER.put(this.in, stacks);
            }
        }

        public String describe() {
            return "Adding Disassembler recipe for " + this.in + " -> " + this.out;
        }
    }
}

