/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.helper.FacCraftTweakerHelper;
import dalapo.factech.plugins.crafttweaker.MasterAdd;
import dalapo.factech.plugins.crafttweaker.ScheduledRemovals;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorytech.Electroplater")
@ZenRegister
public class Electroplater {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input) {
        for (IItemStack in : input.getItems()) {
            CraftTweakerAPI.apply((IAction)new Add((ItemStack)in.getInternal(), (ItemStack)output.getInternal()));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        for (IItemStack out : output.getItems()) {
            CraftTweakerAPI.apply((IAction)new Remove(FacCraftTweakerHelper.toStack(out)));
        }
    }

    private static class Remove
    implements IAction {
        ItemStack output;

        public Remove(ItemStack o) {
            this.output = o;
        }

        public void apply() {
            ScheduledRemovals.INSTANCE.scheduleRemoval(MachineRecipes.ELECTROPLATER, this.output);
        }

        public String describe() {
            return "Removing Electroplater recipe for " + this.output;
        }
    }

    private static class Add
    extends MasterAdd<ItemStack, ItemStack> {
        private ItemStack in;
        private ItemStack out;

        public Add(ItemStack in, ItemStack out) {
            super(in, out, true, MachineRecipes.ELECTROPLATER);
        }

        public String describe() {
            return "Adding Electroplater recipe for " + this.in + " -> " + this.out;
        }
    }
}

