/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.plugins.crafttweaker.MasterAdd;
import dalapo.factech.plugins.crafttweaker.ScheduledRemovals;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorytech.Grindstone")
@ZenRegister
public class Grindstone {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, boolean worksWithBad) {
        for (IItemStack in : input.getItems()) {
            CraftTweakerAPI.apply((IAction)new Add((ItemStack)in.getInternal(), (ItemStack)output.getInternal(), worksWithBad));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        for (IItemStack out : output.getItems()) {
            CraftTweakerAPI.apply((IAction)new Remove((ItemStack)out.getInternal()));
        }
    }

    private static class Remove
    implements IAction {
        ItemStack output;

        public Remove(ItemStack o) {
            this.output = o;
        }

        public void apply() {
            ScheduledRemovals.INSTANCE.scheduleRemoval(MachineRecipes.GRINDSTONE, this.output);
        }

        public String describe() {
            return "Removing Grindstone recipe for " + this.output;
        }
    }

    private static class Add
    extends MasterAdd<ItemStack, ItemStack> {
        public Add(ItemStack in, ItemStack out, boolean worksWithBad) {
            super(in, out, worksWithBad, MachineRecipes.GRINDSTONE);
        }

        public String describe() {
            return "Adding Grindstone recipe for " + this.input + " -> " + this.output;
        }
    }
}

