/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.plugins.crafttweaker.MasterAdd;
import dalapo.factech.plugins.crafttweaker.ScheduledRemovals;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorytech.Refrigerator")
@ZenRegister
public class Refrigerator {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, boolean worksWithBad) {
        for (ILiquidStack in : input.getLiquids()) {
            CraftTweakerAPI.apply((IAction)new Add((FluidStack)in.getInternal(), (ItemStack)output.getInternal(), worksWithBad));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        for (IItemStack out : output.getItems()) {
            CraftTweakerAPI.apply((IAction)new Remove((ItemStack)out.getInternal()));
        }
    }

    private static class Remove
    implements IAction {
        ItemStack output;

        public Remove(ItemStack o) {
            this.output = o;
        }

        public void apply() {
            ScheduledRemovals.INSTANCE.scheduleRemoval(MachineRecipes.REFRIGERATOR, this.output);
        }

        public String describe() {
            return "Removing Refrigerator recipe for " + this.output;
        }
    }

    private static class Add
    extends MasterAdd<FluidStack, ItemStack> {
        public Add(FluidStack in, ItemStack out, boolean worksWithBad) {
            super(in, out, worksWithBad, MachineRecipes.REFRIGERATOR);
        }

        public String describe() {
            return "Adding Refrigerator recipe for " + this.input + " -> " + this.output;
        }
    }
}

