/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.plugins.crafttweaker;

import dalapo.factech.auxiliary.IMachineRecipe;
import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.helper.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ScheduledRemovals {
    private List<Pair<List, Integer>> removals = new ArrayList<Pair<List, Integer>>();
    public static final ScheduledRemovals INSTANCE = new ScheduledRemovals();

    public void scheduleRemoval(List<? extends IMachineRecipe> list, int index) {
        this.removals.add(new Pair<List<? extends IMachineRecipe>, Integer>(list, index));
    }

    public void scheduleRemoval(List<? extends IMachineRecipe<ItemStack>> list, ItemStack is) {
        for (int i = 0; i < list.size(); ++i) {
            IMachineRecipe<ItemStack> recipe = list.get(i);
            ItemStack stack = recipe.getOutputStack();
            if (!FacStackHelper.areItemStacksIdentical(stack, is)) continue;
            this.scheduleRemoval(list, i);
        }
    }

    public void scheduleRemoval(List<? extends IMachineRecipe<FluidStack>> list, FluidStack fs) {
        for (int i = 0; i < list.size(); ++i) {
            IMachineRecipe<FluidStack> recipe = list.get(i);
            FluidStack stack = recipe.getOutputStack();
            if (!FacStackHelper.areFluidStacksIdentical(stack, fs)) continue;
            this.scheduleRemoval(list, i);
        }
    }

    public void removeAll() {
        for (Pair<List, Integer> p : this.removals) {
            ((List)p.a).set((Integer)p.b, null);
        }
        for (Pair<List, Integer> p : this.removals) {
            ((List)p.a).removeIf(recipe -> recipe == null);
        }
    }
}

