/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.plugins.crafttweaker.ScheduledAdditions;
import dalapo.factech.plugins.crafttweaker.ScheduledRemovals;
import dalapo.factech.tileentity.specialized.TileEntityTemperer;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorytech.Temperer")
@ZenRegister
public class Temperer {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, int time) {
        for (IItemStack in : input.getItems()) {
            CraftTweakerAPI.apply((IAction)new Add((ItemStack)in.getInternal(), (ItemStack)output.getInternal(), time));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        for (IItemStack out : output.getItems()) {
            CraftTweakerAPI.apply((IAction)new Remove((ItemStack)out.getInternal()));
        }
    }

    private static class Remove
    implements IAction {
        ItemStack output;

        public Remove(ItemStack o) {
            this.output = o;
        }

        public void apply() {
            ScheduledRemovals.INSTANCE.scheduleRemoval(MachineRecipes.TEMPERER, this.output);
        }

        public String describe() {
            return "Removing Temperer recipe for " + this.output;
        }
    }

    private static class Add
    implements IAction {
        private ItemStack in;
        private ItemStack out;
        private int time;

        public Add(ItemStack in, ItemStack out, int time) {
            this.in = in;
            this.out = out;
            this.time = time;
        }

        public void apply() {
            ScheduledAdditions.scheduleAddition(MachineRecipes.TEMPERER, new TileEntityTemperer.TempererRecipe(this.in, this.out, this.time));
        }

        public String describe() {
            return "Adding Temperer recipe for " + this.in + " -> " + this.out + "(" + this.time + " ticks)";
        }
    }
}

