/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.plugins.jei.wrappers;

import dalapo.factech.helper.FacFluidRenderHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.plugins.jei.BaseRecipeWrapper;
import dalapo.factech.tileentity.specialized.TileEntityAgitator;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class AgitatorRecipeWrapper
extends BaseRecipeWrapper {
    private FluidStack fluidIn1;
    private FluidStack fluidIn2;
    private ItemStack itemIn;
    private FluidStack fluidOut;
    private ItemStack itemOut;

    public AgitatorRecipeWrapper(TileEntityAgitator.AgitatorRecipe recipe) {
        this.fluidIn1 = recipe.getInputFluid(0);
        this.fluidIn2 = recipe.getInputFluid(1);
        this.itemIn = recipe.getInputItem();
        this.fluidOut = recipe.getOutputFluid();
        this.itemOut = recipe.getOutputItem();
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        fluids.add(this.fluidIn1);
        fluids.add(this.fluidIn2);
        ingredients.setInputs(FluidStack.class, fluids);
        ingredients.setInput(ItemStack.class, (Object)this.itemIn);
        ingredients.setOutput(FluidStack.class, (Object)this.fluidOut);
        ingredients.setOutput(ItemStack.class, (Object)this.itemOut);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        FacFluidRenderHelper.drawFluid(this.fluidIn1, 4, 50, 16, 3);
        FacFluidRenderHelper.drawFluid(this.fluidIn2, 22, 50, 16, 3);
        FacFluidRenderHelper.drawFluid(this.fluidOut, 76, 50, 16, 3);
    }

    @Override
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> tooltips = new ArrayList<String>();
        if (FacMathHelper.isInRange(mouseY, 4, 52)) {
            if (FacMathHelper.isInRange(mouseX, 4, 20) && this.fluidIn1 != null) {
                tooltips.add(this.fluidIn1.getLocalizedName());
                tooltips.add("mB: " + this.fluidIn1.amount);
            } else if (FacMathHelper.isInRange(mouseX, 22, 38) && this.fluidIn2 != null) {
                tooltips.add(this.fluidIn2.getLocalizedName());
                tooltips.add("mB: " + this.fluidIn2.amount);
            } else if (FacMathHelper.isInRange(mouseX, 76, 92) && this.fluidOut != null) {
                tooltips.add(this.fluidOut.getLocalizedName());
                tooltips.add("mB: " + this.fluidOut.amount);
            }
        }
        return tooltips;
    }
}

