/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.render.tesr;

import dalapo.factech.helper.FacEntityHelper;
import dalapo.factech.helper.FacRenderHelper;
import dalapo.factech.helper.FacTesrHelper;
import dalapo.factech.init.ItemRegistry;
import dalapo.factech.reference.StateList;
import dalapo.factech.tileentity.TileEntityBase;
import dalapo.factech.tileentity.TileEntityMachine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class TesrMachine<T extends TileEntityBase>
extends TileEntitySpecialRenderer<T> {
    private IModel model;
    private IBakedModel bakedModel;
    protected boolean isDirectional;

    public TesrMachine(boolean directional) {
        this.isDirectional = directional;
        this.func_190053_a(false);
    }

    protected String getModelName() {
        return null;
    }

    protected IBakedModel getBakedModel() {
        if (this.getModelName() == null) {
            return null;
        }
        try {
            IModel model = OBJLoader.INSTANCE.loadModel(new ResourceLocation("factorytech", String.format("models/block/%s.obj", this.getModelName())));
            IBakedModel bakedModel = model.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176600_a, FacTesrHelper::getAtlasFromLocation);
            return bakedModel;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public abstract void doRender(T var1, double var2, double var4, double var6, float var8, int var9, float var10);

    public void renderBox(TileEntityMachine te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        if (FacEntityHelper.isHoldingItem((EntityPlayer)mc.field_71439_g, ItemRegistry.magnifyingGlass) && mc.field_71476_x.func_178782_a() != null && mc.field_71476_x.func_178782_a().equals((Object)te.func_174877_v())) {
            int i;
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
            GlStateManager.func_187441_d((float)2.0f);
            EnumFacing side = te.getPartSide();
            GlStateManager.func_179094_E();
            Tessellator v5 = Tessellator.func_178181_a();
            BufferBuilder buffer = v5.func_178180_c();
            GlStateManager.func_179109_b((float)side.func_82601_c(), (float)side.func_96559_d(), (float)side.func_82599_e());
            GlStateManager.func_179124_c((float)0.0f, (float)1.0f, (float)0.0f);
            buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            FacRenderHelper.Point[] points = new FacRenderHelper.Point[8];
            for (i = 0; i < 8; ++i) {
                points[i] = new FacRenderHelper.Point(i & 1, i >> 1 & 1, i >> 2 & 1);
            }
            for (i = 0; i < 8; ++i) {
                for (int j = 0; j < i; ++j) {
                    boolean doDraw = false;
                    for (int p = 0; p < 3; ++p) {
                        if (points[i].getField(p) != points[j].getField(p)) continue;
                        doDraw = true;
                    }
                    if (!doDraw) continue;
                    FacRenderHelper.drawLine(buffer, points[i], points[j]);
                }
            }
            v5.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179147_l();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179118_c();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
    }

    public void render(T te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        if (te instanceof TileEntityMachine) {
            this.renderBox((TileEntityMachine)te, x, y, z, partialTicks, destroyStage, alpha);
        }
        if (this.isDirectional) {
            try {
                EnumFacing direction = (EnumFacing)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b(StateList.directions);
                switch (direction) {
                    case EAST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case NORTH: {
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case SOUTH: {
                        break;
                    }
                    case UP: {
                        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case DOWN: {
                        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                return;
            }
        }
        this.doRender(te, x, y, z, partialTicks, destroyStage, alpha);
        GlStateManager.func_179121_F();
    }
}

