/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity;

import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.tileentity.TileEntityBase;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileEntityBasicInventory
extends TileEntityBase
implements IInventory {
    protected String name;
    protected String displayName;
    private ItemStack[] inventory;

    public TileEntityBasicInventory(String name, int slots) {
        super(name);
        this.displayName = name;
        this.inventory = new ItemStack[slots];
        for (int i = 0; i < slots; ++i) {
            this.inventory[i] = ItemStack.field_190927_a;
        }
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TextComponentString(I18n.func_135052_a((String)("factorytech.inventory." + this.displayName), (Object[])new Object[0]));
    }

    public void onInventoryChanged(int slot) {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this instanceof ISidedInventory && facing != null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new SidedInvWrapper((ISidedInventory)this, facing){

                    public void onContentsChanged(int slot) {
                        TileEntityBasicInventory.this.onInventoryChanged(slot);
                        TileEntityBasicInventory.this.func_70296_d();
                    }
                });
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new InvWrapper(this){

                public void onContentsChanged(int slot) {
                    TileEntityBasicInventory.this.onInventoryChanged(slot);
                    TileEntityBasicInventory.this.func_70296_d();
                }
            });
        }
        return (T)super.getCapability(capability, facing);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.inventory[i].func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        if (!FacMathHelper.isInRange(index, 0, this.func_70302_i_())) {
            return ItemStack.field_190927_a;
        }
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack is = this.func_70301_a(index).func_77946_l();
        if (count > is.func_190916_E()) {
            count = is.func_190916_E();
        }
        is.func_190920_e(count);
        this.func_70301_a(index).func_190918_g(count);
        this.onInventoryChanged(index);
        this.func_70296_d();
        return is;
    }

    public ItemStack func_70304_b(int index) {
        return this.func_70298_a(index, this.func_70301_a(index).func_190916_E());
    }

    public int containsItem(@Nonnull ItemStack is, int minSlot, int maxSlot) {
        if (minSlot > maxSlot) {
            minSlot += maxSlot;
            maxSlot = minSlot - maxSlot;
            minSlot -= maxSlot;
        }
        for (int i = minSlot; i < maxSlot; ++i) {
            if (!this.inventory[i].func_77969_a(is)) continue;
            return i;
        }
        return -1;
    }

    public int containsItem(@Nonnull ItemStack is) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_77969_a(is)) continue;
            return i;
        }
        return -1;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (FacMathHelper.isInRange(index, 0, this.func_70302_i_())) {
            this.inventory[index] = stack;
        }
        this.onInventoryChanged(index);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = ItemStack.field_190927_a;
        }
        this.onInventoryChanged(0);
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList inv = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag = this.inventory[i].serializeNBT();
            inv.func_74742_a((NBTBase)stackTag);
        }
        nbt.func_74782_a("inventory", (NBTBase)inv);
        return nbt;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("inventory")) {
            NBTTagList inv = nbt.func_150295_c("inventory", 10);
            for (int i = 0; i < inv.func_74745_c(); ++i) {
                this.inventory[i] = new ItemStack(inv.func_150305_b(i));
            }
        }
    }

    @Override
    public void toggleField(int id) {
        if (this.func_174887_a_(id) == 0) {
            this.func_174885_b(id, 1);
        } else {
            this.func_174885_b(id, 0);
        }
        if (!this.field_145850_b.field_72995_K) {
            // empty if block
        }
    }
}

