/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity;

import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.helper.Logger;
import dalapo.factech.tileentity.TileEntityMachine;
import java.util.List;
import net.minecraft.item.ItemStack;

public abstract class TileEntityBasicProcessor
extends TileEntityMachine {
    public TileEntityBasicProcessor(String name, int partSlots) {
        super(name, 1, partSlots, 1);
    }

    @Override
    public void getHasWork() {
        MachineRecipes.MachineRecipe<ItemStack, ItemStack> recipe = this.getRecipe(this.getInput(0));
        if (recipe != null) {
            ItemStack is = recipe.output();
            this.hasWork = !this.getInput(0).func_190926_b() && !is.func_190926_b() && FacStackHelper.canCombineStacks(is, this.getOutput());
        } else {
            this.hasWork = false;
        }
    }

    @Override
    protected boolean performAction() {
        Logger.info("Performing action");
        MachineRecipes.MachineRecipe<ItemStack, ItemStack> curRecipe = this.getRecipe(this.getInput(0));
        boolean success = this.doOutput(curRecipe.output().func_77946_l());
        if (success) {
            this.getIO().extractItemInternal(0, curRecipe.input().func_190916_E(), false);
        }
        this.getHasWork();
        return success;
    }

    protected MachineRecipes.MachineRecipe<ItemStack, ItemStack> getRecipe(ItemStack is) {
        for (MachineRecipes.MachineRecipe<ItemStack, ItemStack> entry : this.getRecipeList()) {
            if (!FacStackHelper.matchStacksWithWildcard(entry.input(), is, false) || is.func_190916_E() < entry.input().func_190916_E()) continue;
            return entry;
        }
        return null;
    }

    protected abstract List<MachineRecipes.MachineRecipe<ItemStack, ItemStack>> getRecipeList();
}

