/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity;

import dalapo.factech.auxiliary.FluidHandlerWrapper;
import dalapo.factech.auxiliary.IHasFluid;
import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacMiscHelper;
import dalapo.factech.tileentity.TileEntityMachine;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public abstract class TileEntityFluidMachine
extends TileEntityMachine
implements IHasFluid {
    protected FluidTank[] tanks;
    private int cutoff;

    public TileEntityFluidMachine(String name, int inSlots, int partSlots, int outSlots, int numTanks, int cutoff) {
        super(name, inSlots, partSlots, outSlots);
        this.tanks = new FluidTank[numTanks];
        this.cutoff = cutoff;
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(10000);
            this.tanks[i].setTileEntity((TileEntity)this);
        }
    }

    @Override
    public void overrideTank(FluidStack fluid, int id) {
        if (FacMathHelper.isInRange(id, 0, this.tanks.length)) {
            this.tanks[id].setFluid(fluid);
        }
    }

    public FluidStack getTankContents(int tank) {
        if (FacMathHelper.isInRange(tank, 0, this.tanks.length)) {
            return this.tanks[tank].getFluid();
        }
        return null;
    }

    @Override
    public FluidTank getTank(int i) {
        return this.tanks[i];
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this.tanks, this.cutoff, this));
        }
        return super.getCapability(capability, facing);
    }

    public void onTankUpdate() {
        FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
        this.getHasWork();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList tankList = new NBTTagList();
        for (FluidTank ft : this.tanks) {
            NBTTagCompound tankInfo = new NBTTagCompound();
            tankInfo.func_74778_a("name", ft.getFluid() == null ? "[empty]" : ft.getFluid().getFluid().getName());
            tankInfo.func_74768_a("amount", ft.getFluidAmount());
            tankList.func_74742_a((NBTBase)tankInfo);
        }
        nbt.func_74782_a("tanks", (NBTBase)tankList);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("tanks")) {
            NBTTagList tankList = nbt.func_150295_c("tanks", 10);
            for (int i = 0; i < tankList.func_74745_c(); ++i) {
                NBTTagCompound tankInfo = tankList.func_150305_b(i);
                if (tankInfo.func_74779_i("name").equals("[empty]")) {
                    this.tanks[i].setFluid(null);
                    continue;
                }
                this.tanks[i].setFluid(new FluidStack(FluidRegistry.getFluid((String)tankInfo.func_74779_i("name")), tankInfo.func_74762_e("amount")));
            }
        }
    }

    @Override
    public List<String> getGlassInfo() {
        List<String> list = super.getGlassInfo();
        for (int i = 0; i < this.tanks.length; ++i) {
            list.add(I18n.func_135052_a((String)"factorytech.tank", (Object[])new Object[]{i + 1, FacMiscHelper.describeTank(this.tanks[i])}));
        }
        return list;
    }
}

