/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity;

import dalapo.factech.auxiliary.QueuedItem;
import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.init.BlockRegistry;
import dalapo.factech.render.tesr.TesrElevator;
import dalapo.factech.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityItemQueue
extends TileEntityBase
implements ITickable {
    protected static boolean canItemsBePushed = true;
    private static final int DELAY = 5;
    private int ticks = 0;
    protected List<QueuedItem> stacks = new ArrayList<QueuedItem>();
    protected LinkedList<ItemStack> scheduled = new LinkedList();
    protected BlockPos targetPos;
    private ItemStack legacy = ItemStack.field_190927_a;

    public abstract BlockPos getTarget();

    protected abstract void ejectItem(ItemStack var1);

    public TileEntityItemQueue(String name) {
        super(name);
    }

    public boolean allowPush() {
        return canItemsBePushed;
    }

    public void onLoad() {
        super.onLoad();
        FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
        this.targetPos = this.getTarget();
    }

    public List<QueuedItem> getStacks(TesrElevator.TESRELEV auth) {
        return this.stacks;
    }

    public ItemStack yank(int index) {
        QueuedItem qi = null;
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (this.stacks.get(i).getTime() != index) continue;
            qi = this.stacks.remove(i);
        }
        FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
        return qi == null ? ItemStack.field_190927_a : qi.getItem();
    }

    public void set(int index, ItemStack is) {
        boolean flag = false;
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (this.stacks.get(i).getTime() != index) continue;
            this.stacks.set(i, new QueuedItem(is, this, index));
            flag = true;
            break;
        }
        if (!flag) {
            this.stacks.add(new QueuedItem(is, this, index));
        }
        FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
    }

    public ItemStack peek(int index) {
        for (QueuedItem qi : this.stacks) {
            if (qi.getTime() != index) continue;
            return qi.getItem();
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getLegacy() {
        return this.legacy;
    }

    public void scheduleItemStack(ItemStack itemstack) {
        this.scheduled.add(itemstack);
    }

    private void scheduleItemStackWithPriority(ItemStack toEject) {
        this.scheduled.addFirst(toEject);
    }

    public void func_73660_a() {
        this.legacy = ItemStack.field_190927_a;
        if (--this.ticks <= 0 && !this.scheduled.isEmpty()) {
            this.stacks.add(new QueuedItem(this.scheduled.remove(), this));
            this.ticks = 5;
            FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
        }
        for (int i = this.stacks.size() - 1; i >= 0; --i) {
            QueuedItem qi = this.stacks.get(i);
            if (!qi.tick()) continue;
            if (!this.field_145850_b.field_72995_K) {
                ItemStack toEject = qi.getItem();
                TileEntity te = this.field_145850_b.func_175625_s(this.targetPos);
                boolean dealtWith = false;
                if (te instanceof TileEntityItemQueue) {
                    ((TileEntityItemQueue)te).scheduleItemStackWithPriority(toEject);
                    dealtWith = true;
                } else if (this.field_145850_b.func_180495_p(this.targetPos).func_177230_c() == BlockRegistry.hatch && (toEject = BlockRegistry.hatch.insertItem(this.field_145850_b, this.targetPos, toEject)).func_190926_b()) {
                    dealtWith = true;
                }
                if (!this.field_145850_b.field_72995_K && !dealtWith) {
                    this.ejectItem(toEject);
                }
            }
            this.legacy = qi.getItem();
            this.stacks.remove(i);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("ticks", this.ticks);
        nbt.func_74772_a("pos", this.targetPos.func_177986_g());
        NBTTagList list = new NBTTagList();
        for (QueuedItem qi : this.stacks) {
            list.func_74742_a((NBTBase)qi.serializeNBT());
        }
        nbt.func_74782_a("items", (NBTBase)list);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.targetPos = BlockPos.func_177969_a((long)nbt.func_74763_f("pos"));
        this.ticks = nbt.func_74762_e("ticks");
        this.stacks.clear();
        NBTTagList list = nbt.func_150295_c("items", 10);
        for (NBTBase tag : list) {
            if (!(tag instanceof NBTTagCompound)) {
                throw new RuntimeException("Somehow a non-itemstack has been stored in this list. Somebody should probably be fired over this.");
            }
            this.stacks.add(new QueuedItem((NBTTagCompound)tag, this));
        }
    }

    public void func_145843_s() {
        for (QueuedItem qi : this.stacks) {
            if (this.field_145850_b.field_72995_K || qi.getItem().func_190926_b()) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, qi.getItem()));
        }
        super.func_145843_s();
    }

    public int getCapacity() {
        return 20;
    }
}

