/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity;

import dalapo.factech.FactoryTech;
import dalapo.factech.auxiliary.NewMachinePart;
import dalapo.factech.config.FacTechConfigManager;
import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacTileHelper;
import dalapo.factech.helper.Pair;
import dalapo.factech.init.ItemRegistry;
import dalapo.factech.item.ItemSalvage;
import dalapo.factech.reference.PartList;
import dalapo.factech.tileentity.IMagnifyingGlassInfo;
import dalapo.factech.tileentity.TileEntityBase;
import dalapo.factech.tileentity.automation.TileEntityCrate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityMachine
extends TileEntityBase
implements ITickable,
IMagnifyingGlassInfo {
    protected IOStackHandler io;
    protected PartStackHandler parts;
    protected int inputSlots;
    protected int outputSlots;
    private PartList[] partsNeeded;
    private NewMachinePart[] partsGot;
    protected int installedUpgrade;
    private EnumFacing partInputSide = EnumFacing.DOWN;
    private int[] salvages;
    protected boolean isRunning = false;
    protected boolean hasWork = false;
    protected boolean isDisabledByRedstone = false;
    protected int opTicks;
    private int finalOpTicks;
    private boolean hasLoaded;

    public TileEntityMachine(String name, int inSlots, int partSlots, int outSlots) {
        super(name);
        this.inputSlots = inSlots;
        this.outputSlots = outSlots;
        this.io = new IOStackHandler(inSlots, outSlots, this);
        this.parts = new PartStackHandler(partSlots, this);
        this.partsNeeded = new PartList[partSlots];
        this.partsGot = new NewMachinePart[partSlots];
        this.salvages = new int[partSlots];
        for (int i = 0; i < this.partsNeeded.length; ++i) {
            this.partsNeeded[i] = FacTechConfigManager.allPartsNew.get(this.getClass())[i].id;
            this.partsGot[i] = null;
        }
    }

    protected abstract int getBaseOpTicks();

    protected abstract boolean performAction();

    protected void doRegardless() {
    }

    public void onInventoryChanged(int slot) {
        FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
        this.getHasWork();
    }

    protected void cycleParts() {
        for (int i = 0; i < this.partsGot.length; ++i) {
            boolean flag = this.partsGot[i].isBad();
            if (!this.partsGot[i].tick()) continue;
            if (!flag && FactoryTech.random.nextDouble() <= this.getSalvageChance(this.partsGot[i])) {
                ItemSalvage salvageType = ItemRegistry.salvagePart;
                int salvageDamage = this.salvages[i];
                int salvageNum = 1;
                if (this.partsNeeded[i].hasCustomSalvage()) {
                    salvageType = this.partsNeeded[i].getSalvage();
                    salvageNum = this.partsNeeded[i].getSalvageAmount();
                    salvageDamage = this.partsNeeded[i].getSalvageMeta();
                }
                ItemStack is = new ItemStack((Item)salvageType, salvageNum, salvageDamage);
                Pair<EnumFacing, TileEntity> salvageLocation = FacTileHelper.getFirstAdjacentTile(this.field_174879_c, this.field_145850_b, TileEntityCrate.class);
                if (salvageLocation == null) {
                    EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, is);
                    this.field_145850_b.func_72838_d((Entity)item);
                } else {
                    ItemStack remaining = FacTileHelper.tryInsertItem((IItemHandler)((TileEntity)salvageLocation.b).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, ((EnumFacing)salvageLocation.a).func_176734_d()), is, ((EnumFacing)salvageLocation.a).func_176734_d().func_176745_a());
                    EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, remaining);
                    this.field_145850_b.func_72838_d((Entity)item);
                }
            }
            this.partsGot[i] = null;
        }
    }

    private double getSalvageChance(NewMachinePart part) {
        double d = 1.0 - part.getSalvageChance();
        if (this.installedUpgrade == 5) {
            d /= 2.0;
        }
        return 1.0 - d;
    }

    protected void replenishParts() {
        for (int i = 0; i < this.partsGot.length; ++i) {
            ItemStack reserve;
            if (this.partsGot[i] != null || (reserve = this.parts.getStackInSlot(i)).func_190926_b() || reserve.func_77973_b() != ItemRegistry.machinePart || PartList.getPartFromDamage(reserve.func_77952_i()) != this.partsNeeded[i]) continue;
            MachinePartBlueprint mpb = FacTechConfigManager.allPartsNew.get(this.getClass())[i];
            int quality = PartList.getQualityFromDamage(reserve.func_77952_i());
            this.partsGot[i] = new NewMachinePart((int)((double)mpb.startingLife * mpb.id.getLifetimeModifier(quality)), mpb.chance, mpb.increase, mpb.id.getSpeedModifier(quality), mpb.salvageRate, mpb.id.isBad(quality));
            this.salvages[i] = this.parts.getStackInSlot(i).func_77952_i();
            this.parts.consumePart(i);
        }
    }

    public boolean hasBadParts() {
        for (NewMachinePart p : this.partsGot) {
            if (p == null || !p.isBad()) continue;
            return true;
        }
        return false;
    }

    public void installUpgrade(int upgrade) {
        if (this.installedUpgrade != 0) {
            ItemStack oldUpgrade = new ItemStack((Item)ItemRegistry.upgrade, 1, this.installedUpgrade - 1);
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, oldUpgrade));
        }
        this.installedUpgrade = upgrade;
        FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
        this.func_70296_d();
    }

    protected boolean canRun() {
        if (this.isDisabledByRedstone && this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
            return false;
        }
        for (NewMachinePart p : this.partsGot) {
            if (p != null) continue;
            return false;
        }
        return this.hasWork;
    }

    public void onLoad() {
        this.getHasWork();
    }

    public void func_73660_a() {
        if (this.canRun()) {
            this.isRunning = true;
            if (this.opTicks++ >= this.getTicksPerOperation()) {
                if (!this.field_145850_b.field_72995_K) {
                    if (this.performAction()) {
                        this.cycleParts();
                        this.getHasWork();
                    }
                    this.func_70296_d();
                    this.sync();
                }
                this.opTicks = 0;
            }
        } else {
            this.isRunning = false;
            this.opTicks = 0;
        }
        if (this.finalOpTicks++ >= 20) {
            this.doRegardless();
            this.finalOpTicks = 0;
        }
        this.replenishParts();
    }

    private int getTicksPerOperation() {
        int base = this.getBaseOpTicks();
        for (NewMachinePart p : this.partsGot) {
            if (p == null) continue;
            base = (int)((double)base / p.getSpeedMultiplier());
        }
        switch (this.installedUpgrade) {
            case 1: {
                base = (int)((double)base / 2.0);
                break;
            }
            case 2: {
                base = (int)((double)base * 2.0);
                break;
            }
            case 3: {
                base = (int)((double)base * 1.25);
            }
        }
        return base;
    }

    @Override
    public List<String> getGlassInfo() {
        return new ArrayList<String>();
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(cap, side);
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)(side == this.partInputSide ? this.parts : this.io));
        }
        return (T)super.getCapability(cap, side);
    }

    public void getHasWork() {
        this.hasWork = true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("IO", (NBTBase)this.io.serializeNBT());
        nbt.func_74782_a("partReserves", (NBTBase)this.parts.serializeNBT());
        nbt.func_74768_a("partSide", this.partInputSide.func_176745_a());
        nbt.func_74768_a("age", this.opTicks);
        nbt.func_74768_a("installedUpgrade", this.installedUpgrade);
        NBTTagList partList = new NBTTagList();
        NBTTagList salvages = new NBTTagList();
        for (NewMachinePart p : this.partsGot) {
            if (p == null) {
                partList.func_74742_a((NBTBase)new NBTTagString("missing"));
                continue;
            }
            partList.func_74742_a((NBTBase)p.serializeNBT());
        }
        for (int i : this.salvages) {
            salvages.func_74742_a((NBTBase)new NBTTagInt(i));
        }
        nbt.func_74782_a("parts", (NBTBase)partList);
        nbt.func_74782_a("salvages", (NBTBase)salvages);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("IO")) {
            this.io.deserializeNBT((NBTTagCompound)nbt.func_74781_a("IO"));
        }
        if (nbt.func_74764_b("partReserves")) {
            this.parts.deserializeNBT((NBTTagCompound)nbt.func_74781_a("partReserves"));
        }
        if (nbt.func_74764_b("partSide")) {
            this.partInputSide = EnumFacing.func_82600_a((int)nbt.func_74762_e("partSide"));
        }
        if (nbt.func_74764_b("age")) {
            this.opTicks = nbt.func_74762_e("age");
        }
        if (nbt.func_74764_b("installedUpgrade")) {
            this.installedUpgrade = nbt.func_74762_e("installedUpgrade");
        }
        if (nbt.func_74764_b("parts") && nbt.func_74764_b("salvages")) {
            NBTTagList list = nbt.func_150295_c("parts", 8);
            NBTTagList s = nbt.func_150295_c("salvages", 3);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                String str = list.func_150307_f(i);
                this.partsGot[i] = str.equals("missing") ? null : new NewMachinePart(str);
                this.salvages[i] = s.func_186858_c(i);
            }
        }
    }

    public void setActualPartSide(EnumFacing newSide) {
        this.partInputSide = newSide;
    }

    public EnumFacing getPartSide() {
        return this.partInputSide;
    }

    public ItemStack getInput(int slot) {
        return this.io.getStackInSlot(slot);
    }

    public ItemStack getOutput(int slot) {
        return this.io.getStackInSlot(this.inputSlots + slot);
    }

    public ItemStack getInput() {
        return this.getInput(0);
    }

    public ItemStack getOutput() {
        return this.getOutput(0);
    }

    public void setOutput(int slot, ItemStack is) {
        this.io.extractItemInternal(slot + this.inputSlots, Integer.MAX_VALUE, false);
        this.io.insertItemInternal(slot + this.inputSlots, is.func_77946_l(), false);
    }

    public void setOutput(ItemStack is) {
        this.setOutput(0, is);
    }

    public boolean doOutput(ItemStack out) {
        for (int i = this.inputSlots; i < this.io.getSlots(); ++i) {
            ItemStack is = this.io.getStackInSlot(i);
            if (!this.io.insertItemInternal(i, out, true).func_190926_b()) continue;
            this.io.insertItemInternal(i, out, false);
            return true;
        }
        return false;
    }

    public boolean doOutput(ItemStack out, int slot) {
        if (this.io.insertItemInternal(this.inputSlots + slot, out.func_77946_l(), true).func_190926_b()) {
            this.io.insertItemInternal(this.inputSlots + slot, out.func_77946_l(), false);
            return true;
        }
        return false;
    }

    public int countPartSlots() {
        return this.parts.getSlots();
    }

    public PartList[] getPartsNeeded() {
        return this.partsNeeded;
    }

    public boolean hasPart(int slot) {
        return FacMathHelper.isInRange(slot, 0, this.partsGot.length) && this.partsGot[slot] != null;
    }

    public double getRelativePartDurability(int slot) {
        if (FacMathHelper.isInRange(slot, 0, this.partsGot.length)) {
            return (double)this.partsGot[slot].getRemainingOperations() / (double)this.partsGot[slot].getMaxLife();
        }
        return 0.0;
    }

    public IOStackHandler getIO() {
        return this.io;
    }

    public PartStackHandler getParts() {
        return this.parts;
    }

    public int getAge() {
        return this.opTicks;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public double getLifetimeRatio(int slot) {
        if (!FacMathHelper.isInRange(slot, 0, this.countPartSlots())) {
            return -1.0;
        }
        return (double)this.partsGot[slot].getRemainingOperations() / (double)this.partsGot[slot].getMaxLife();
    }

    @Override
    public int getComparatorOverride() {
        for (int i = 0; i < this.countPartSlots(); ++i) {
            if (this.hasPart(i)) continue;
            return 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getProgressScaled(int pixelSize) {
        return (int)((double)this.opTicks / (double)this.getTicksPerOperation() * (double)pixelSize);
    }

    protected boolean canInsertIntoThisSlot(int slot, ItemStack item) {
        return true;
    }

    public static class MachinePartBlueprint {
        public final PartList id;
        public final int startingLife;
        public final float chance;
        public final float increase;
        public final float salvageRate;

        public MachinePartBlueprint(PartList id, int sl, float c, float i, float sr) {
            this.id = id;
            this.startingLife = sl;
            this.chance = c;
            this.increase = i;
            this.salvageRate = sr;
        }
    }

    public class PartStackHandler
    extends MachineStackHandler {
        TileEntityMachine tile;

        PartStackHandler(int slots, TileEntityMachine te) {
            super(slots);
            this.tile = te;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!FacMathHelper.isInRange(slot, 0, this.getSlots()) || stack.func_77973_b() != ItemRegistry.machinePart) {
                return stack;
            }
            if (this.getStackInSlot(slot).func_190926_b() && PartList.getPartFromDamage(stack.func_77952_i()) == TileEntityMachine.this.partsNeeded[slot]) {
                if (!simulate) {
                    this.stacks.set(slot, (Object)stack.func_77946_l());
                }
                return ItemStack.field_190927_a;
            }
            if (stack.func_77969_a(this.getStackInSlot(slot))) {
                ItemStack toReturn = stack.func_77946_l();
                int toAdd = Math.min(stack.func_190916_E(), stack.func_77976_d() - ((ItemStack)this.stacks.get(slot)).func_190916_E());
                if (!simulate) {
                    ((ItemStack)this.stacks.get(slot)).func_190917_f(toAdd);
                }
                toReturn.func_190918_g(toAdd);
                return toReturn;
            }
            TileEntityMachine.this.onInventoryChanged(slot);
            return stack;
        }

        @Override
        public ItemStack insertItemInternal(int slot, ItemStack stack, boolean simulate) {
            return this.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        @Override
        public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }

        void consumePart(int slot) {
            ((ItemStack)this.stacks.get(slot)).func_190918_g(1);
            TileEntityMachine.this.onInventoryChanged(slot);
        }

        public int getSlotLimit(int slot) {
            return FacTechConfigManager.maxPartStackSize;
        }

        public void setStackInSlot(int slot, ItemStack is) {
            if (FacMathHelper.isInRange(slot, 0, this.getSlots())) {
                super.setStackInSlot(slot, is.func_77946_l());
            }
            TileEntityMachine.this.onInventoryChanged(slot);
        }
    }

    public class IOStackHandler
    extends MachineStackHandler {
        int inSlots;
        int outSlots;
        TileEntityMachine tile;

        protected IOStackHandler(int inputSlots, int outputSlots, TileEntityMachine te) {
            super(inputSlots + outputSlots);
            this.inSlots = inputSlots;
            this.outSlots = outputSlots;
            this.tile = te;
        }

        public ItemStack insertItem(int slot, ItemStack item, boolean simulate) {
            if (slot >= this.inSlots || !TileEntityMachine.this.canInsertIntoThisSlot(slot, item)) {
                return item;
            }
            ItemStack is = super.insertItem(slot, item, simulate);
            return is;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < this.inSlots) {
                return ItemStack.field_190927_a;
            }
            ItemStack is = super.extractItem(slot, amount, simulate);
            return is;
        }

        @Override
        public ItemStack insertItemInternal(int slot, ItemStack item, boolean simulate) {
            ItemStack is = super.insertItem(slot, item, simulate);
            return is;
        }

        @Override
        public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
            ItemStack is = super.extractItem(slot, amount, simulate);
            return is;
        }

        public void setSlotCount(int slot, int count) {
            ((ItemStack)this.stacks.get(slot)).func_190920_e(count);
        }

        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityMachine.this.onInventoryChanged(slot);
        }
    }

    public abstract class MachineStackHandler
    extends ItemStackHandler {
        protected MachineStackHandler(int slots) {
            super(slots);
        }

        public abstract ItemStack insertItemInternal(int var1, ItemStack var2, boolean var3);

        public abstract ItemStack extractItemInternal(int var1, int var2, boolean var3);
    }
}

