/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity;

import dalapo.factech.FactoryTech;
import dalapo.factech.auxiliary.MachinePart;
import dalapo.factech.config.FacTechConfigManager;
import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.helper.FacChatHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.helper.FacTileHelper;
import dalapo.factech.helper.Logger;
import dalapo.factech.helper.Pair;
import dalapo.factech.init.ItemRegistry;
import dalapo.factech.item.ItemMachinePart;
import dalapo.factech.reference.PartList;
import dalapo.factech.reference.StateList;
import dalapo.factech.tileentity.IMagnifyingGlassInfo;
import dalapo.factech.tileentity.TileEntityBasicInventory;
import dalapo.factech.tileentity.automation.TileEntityCrate;
import dalapo.factech.tileentity.specialized.TileEntityEnergizer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityOldMachine
extends TileEntityBasicInventory
implements ITickable,
ISidedInventory,
IMagnifyingGlassInfo {
    private boolean hasLoaded = false;
    private boolean hasBadParts = false;
    protected static int ID = -1;
    protected float[][] kValue;
    protected boolean shouldUpdate;
    protected MachinePart[] partsNeeded;
    protected int[] partsGot;
    protected int opTime;
    protected int partSlots;
    protected int inSlots;
    protected int outSlots;
    protected boolean hasWork;
    protected boolean isRunning;
    protected boolean isDisabledByRedstone = false;
    protected RelativeSide partSide;
    protected EnumFacing actualPartSide;
    public boolean isCharged;
    protected int installedUpgrade;
    public int age;

    public TileEntityOldMachine(String name, int inSlots, int partSlots, int outSlots, RelativeSide partSide) {
        super(name, inSlots + partSlots + outSlots);
        this.name = name;
        this.opTime = this.getOpTime();
        this.inSlots = inSlots;
        this.partSlots = partSlots;
        this.outSlots = outSlots;
        this.partSide = partSide;
        this.initArrays();
        this.fillMachineParts();
        this.age = 0;
        this.installedUpgrade = 0;
    }

    public void onLoad() {
        super.onLoad();
        this.getHasWork();
    }

    protected boolean checkForEnergize() {
        boolean flag = false;
        for (int i = 0; i < 6; ++i) {
            TileEntity te = this.field_145850_b.func_175625_s(FacMathHelper.withOffset(this.field_174879_c, EnumFacing.func_82600_a((int)i)));
            if (!(te instanceof TileEntityEnergizer) || !((TileEntityEnergizer)te).isCharging()) continue;
            flag = true;
        }
        return flag;
    }

    private double getAdjustedChance(double baseChance) {
        if (baseChance <= 0.0) {
            return 0.0;
        }
        if (this.installedUpgrade != 4 || baseChance >= 1.0) {
            return baseChance;
        }
        double d = (1.0 - baseChance) / 2.0;
        return 1.0 - d;
    }

    protected void consumeParts() {
        for (int i = 0; i < this.partSlots; ++i) {
            if (this.partsNeeded[i].shouldBreak()) {
                IItemHandler storage;
                this.partsGot[i] = 0;
                double d = FactoryTech.random.nextDouble();
                if (!(d < this.getAdjustedChance(this.partsNeeded[i].salvageChance)) || this.partsNeeded[i].isBad()) continue;
                boolean flag = false;
                Pair<EnumFacing, TileEntity> cratePos = FacTileHelper.getFirstAdjacentTile(this.field_174879_c, this.field_145850_b, TileEntityCrate.class);
                if (cratePos != null && FacTileHelper.hasSpaceForItem(storage = (IItemHandler)((TileEntityCrate)cratePos.b).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, ((EnumFacing)cratePos.a).func_176734_d()), this.partsNeeded[i].getSalvage(), ((EnumFacing)cratePos.a).func_176734_d(), false)) {
                    flag = true;
                    FacTileHelper.tryInsertItem(storage, this.partsNeeded[i].getSalvage().func_77946_l(), ((EnumFacing)cratePos.a).func_176734_d().ordinal());
                }
                if (flag) continue;
                EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.partsNeeded[i].getSalvage().func_77946_l());
                ei.field_70159_w = 0.0;
                ei.field_70181_x = 0.0;
                ei.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)ei);
                continue;
            }
            this.partsNeeded[i].increaseChance();
        }
    }

    protected void replenishParts() {
        int i;
        for (i = 0; i < this.partSlots; ++i) {
            int slot;
            if (this.partsGot[i] > 0 || (slot = this.hasPartInReserve(this.partsNeeded[i].getPartID())) == -1) continue;
            int tier = PartList.getQualityFromDamage(this.func_70301_a(slot).func_77952_i());
            this.partsNeeded[i].reset(tier);
            this.partsGot[i] = 1;
            this.func_70298_a(slot, 1);
            this.markDirtyLight();
        }
        for (i = 0; i < this.partSlots; ++i) {
            if (!this.partsNeeded[i].isBad()) continue;
            this.hasBadParts = true;
            return;
        }
        this.hasBadParts = false;
    }

    public void func_73660_a() {
        if (!this.hasLoaded) {
            this.direction = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(StateList.directions);
            this.hasLoaded = true;
        }
        if (this.canRun()) {
            this.isRunning = true;
            if (++this.age >= this.getActualOptime()) {
                this.age = 0;
                if (!this.field_145850_b.field_72995_K) {
                    if (this.performAction()) {
                        this.consumeParts();
                        this.getHasWork();
                    }
                    this.func_70296_d();
                    this.syncToAll();
                }
            }
        } else {
            this.age = 0;
            this.isRunning = false;
        }
        this.replenishParts();
    }

    public void installUpgrade(int upgrade) {
        if (this.installedUpgrade != 0) {
            ItemStack oldUpgrade = new ItemStack((Item)ItemRegistry.upgrade, 1, this.installedUpgrade - 1);
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, oldUpgrade));
        }
        this.installedUpgrade = upgrade;
        this.syncToAll();
        this.func_70296_d();
    }

    public int getInstalledUpgrade() {
        return this.installedUpgrade;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getTheoreticalRemainingOperations(int slot) {
        if (!FacMathHelper.isInRange(slot, 0, this.partSlots)) {
            return -1;
        }
        return this.partsNeeded[slot].getRemainingOperations();
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.getHasWork();
    }

    public double getLifetimeRatio(int slot) {
        if (!FacMathHelper.isInRange(slot, 0, this.partSlots)) {
            return -1.0;
        }
        return (double)this.partsNeeded[slot].getRemainingOperations() / (double)this.partsNeeded[slot].getActualMin();
    }

    public EnumFacing[] getTruePartSides() {
        if (this.actualPartSide != null) {
            return new EnumFacing[]{this.actualPartSide};
        }
        if (this.direction == null) {
            this.direction = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(StateList.directions);
        }
        switch (this.partSide) {
            case ANY: {
                return EnumFacing.field_82609_l;
            }
            case TOP: {
                return new EnumFacing[]{EnumFacing.UP};
            }
            case BOTTOM: {
                return new EnumFacing[]{EnumFacing.DOWN};
            }
            case SIDE: {
                return new EnumFacing[]{this.direction.func_176746_e(), this.direction.func_176735_f()};
            }
            case FRONT: {
                return new EnumFacing[]{this.direction};
            }
            case BACK: {
                return new EnumFacing[]{this.direction.func_176734_d()};
            }
        }
        return new EnumFacing[0];
    }

    protected boolean hasBadParts() {
        return this.hasBadParts;
    }

    private int getActualOptime() {
        int adjustedOptime = this.opTime;
        switch (this.installedUpgrade) {
            case 1: {
                adjustedOptime /= 2;
                break;
            }
            case 2: {
                adjustedOptime *= 2;
                break;
            }
            case 3: {
                adjustedOptime = (int)((double)adjustedOptime * 1.25);
            }
        }
        for (MachinePart p : this.partsNeeded) {
            adjustedOptime = (int)((double)adjustedOptime / p.getSpeed());
        }
        return adjustedOptime;
    }

    protected boolean doOutput(Item out, int amt, int dmg, int outSlot) {
        if (this.getOutput(outSlot).func_190926_b()) {
            this.setOutput(outSlot, new ItemStack(out, amt, dmg));
            return true;
        }
        if (this.getOutput(outSlot).func_77973_b() == out && this.getOutput(outSlot).func_77952_i() == dmg && this.getOutput(outSlot).func_190916_E() + amt <= this.getOutput(outSlot).func_77976_d()) {
            this.getOutput(outSlot).func_190917_f(amt);
            return true;
        }
        return false;
    }

    protected boolean doOutput(ItemStack out, int outSlot) {
        if (this.getOutput(outSlot).func_190926_b()) {
            this.setOutput(outSlot, out);
            return true;
        }
        if (FacStackHelper.canCombineStacks(this.getOutput(outSlot), out)) {
            this.getOutput(outSlot).func_190917_f(out.func_190916_E());
            return true;
        }
        return false;
    }

    protected boolean doOutput(ItemStack out) {
        for (int i = 0; i < this.outSlots; ++i) {
            if (this.getOutput(i).func_190926_b()) {
                this.setOutput(i, out.func_77946_l());
                return true;
            }
            if (!FacStackHelper.canCombineStacks(this.getOutput(i), out)) continue;
            this.getOutput(i).func_190917_f(out.func_190916_E());
            return true;
        }
        return false;
    }

    protected boolean doOutput(NonNullList<ItemStack> outs) {
        boolean success = true;
        for (ItemStack is : outs) {
            if (this.doOutput(is)) continue;
            success = false;
        }
        return success;
    }

    public void getHasWork() {
        this.hasWork = true;
    }

    @Override
    public int getSlotLimit(int slot) {
        if (!FacMathHelper.isInRange(slot, 0, this.func_70302_i_())) {
            return -1;
        }
        if (slot < this.inSlots || slot >= this.inSlots + this.partSlots) {
            return 64;
        }
        return 4;
    }

    public String getContainerName() {
        return this.name;
    }

    public ItemStack getInput(int i) {
        if (i < this.inSlots && i >= 0) {
            return this.func_70301_a(i);
        }
        return null;
    }

    public ItemStack getInput() {
        return this.getInput(0);
    }

    public ItemStack getBuffer(int i) {
        if (i < this.partSlots && i >= 0) {
            return this.func_70301_a(i + this.inSlots);
        }
        return null;
    }

    @Deprecated
    public int getProgressScaled() {
        return this.getProgressScaled(21);
    }

    public int getProgressScaled(int pixelSize) {
        return (int)((double)this.age / (double)this.getActualOptime() * (double)pixelSize);
    }

    public ItemStack getOutput(int slot) {
        if (slot >= 0 && slot < this.outSlots) {
            return this.func_70301_a(this.inSlots + this.partSlots + slot);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getOutput() {
        return this.getOutput(0);
    }

    protected void syncToAll() {
        FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
    }

    public PartList[] getPartsNeeded() {
        PartList[] parts = new PartList[this.partsNeeded.length];
        for (int i = 0; i < this.partsNeeded.length; ++i) {
            parts[i] = this.partsNeeded[i].id;
        }
        return parts;
    }

    protected void setOutput(int slot, ItemStack is) {
        if (slot >= 0 && slot < this.outSlots) {
            this.func_70299_a(this.inSlots + this.partSlots + slot, is);
        }
    }

    protected void setOutput(ItemStack is) {
        this.setOutput(0, is);
    }

    public void setActualPartSide(EnumFacing side) {
        this.actualPartSide = side;
    }

    public int countPartSlots() {
        return this.partSlots;
    }

    public PartList getPartID(int slot) {
        if (FacMathHelper.isInRange(slot, 0, this.partsNeeded.length)) {
            return this.partsNeeded[slot].getPartID();
        }
        return null;
    }

    public boolean hasPart(int slot) {
        if (FacMathHelper.isInRange(slot, 0, this.partsGot.length)) {
            return this.partsGot[slot] != 0;
        }
        return false;
    }

    public void copyParts(int[] parts) {
        try {
            for (int i = 0; i < this.partsGot.length; ++i) {
                this.partsGot[i] = parts[i];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logger.warn("copyParts called with an insufficient array");
        }
    }

    public void showChatInfo(EntityPlayer ep) {
        String str = "Installed upgrade: ";
        switch (this.installedUpgrade) {
            case 1: {
                str = str + "Overclock";
                break;
            }
            case 2: {
                str = str + "Underclock";
                break;
            }
            case 3: {
                str = str + "Range";
                break;
            }
            case 4: {
                str = str + "Consistency";
                break;
            }
            case 5: {
                str = str + "Efficiency";
                break;
            }
            default: {
                str = str + "None";
            }
        }
        FacChatHelper.sendChatToPlayer(ep, str);
        String side = "Part input side: ";
        side = this.actualPartSide == null ? side + this.partSide.name() : side + this.actualPartSide.name();
        FacChatHelper.sendChatToPlayer(ep, side);
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == this.func_70302_i_() - this.outSlots) {
            return false;
        }
        if (index < this.inSlots) {
            return true;
        }
        return stack.func_77973_b() instanceof ItemMachinePart;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] slots = new int[this.inSlots + this.partSlots + this.outSlots];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        EnumFacing orientation = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(StateList.directions);
        boolean isPartSide = false;
        if (this.actualPartSide != null) {
            isPartSide = direction == this.actualPartSide;
        } else {
            switch (this.partSide) {
                case NONE: {
                    isPartSide = false;
                    break;
                }
                case ANY: {
                    isPartSide = true;
                    break;
                }
                case FRONT: {
                    if (orientation != direction) break;
                    isPartSide = true;
                    break;
                }
                case BACK: {
                    if (orientation != direction.func_176734_d()) break;
                    isPartSide = true;
                    break;
                }
                case SIDE: {
                    if (orientation == direction || orientation == direction.func_176734_d() || orientation == EnumFacing.UP || orientation == EnumFacing.DOWN) break;
                    isPartSide = true;
                    break;
                }
                case TOP: {
                    if (!direction.equals((Object)EnumFacing.UP)) break;
                    isPartSide = true;
                    break;
                }
                case BOTTOM: {
                    if (!direction.equals((Object)EnumFacing.DOWN)) break;
                    isPartSide = true;
                }
            }
        }
        if (isPartSide) {
            if (itemStackIn.func_77973_b() != ItemRegistry.machinePart) {
                return false;
            }
            PartList id = PartList.getPartFromDamage(itemStackIn.func_77952_i());
            for (int i = 0; i < this.partsNeeded.length; ++i) {
                if (this.partsNeeded[i].id != id) continue;
                return index == this.inSlots + i;
            }
            return false;
        }
        return index < this.inSlots;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index >= this.inSlots + this.partSlots;
    }

    private void initArrays() {
        this.partsGot = new int[this.partSlots];
        this.partsNeeded = new MachinePart[this.partSlots];
    }

    protected boolean canRun() {
        if (this.isDisabledByRedstone && this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
            return false;
        }
        for (int i : this.partsGot) {
            if (i != 0) continue;
            return false;
        }
        return true;
    }

    public void func_174885_b(int id, int val) {
        if (id == 0) {
            this.age = val;
        } else if (id < this.func_174890_g()) {
            this.partsGot[id - 1] = val;
        }
    }

    public int func_174887_a_(int id) {
        if (id == 0) {
            return this.age;
        }
        if (id < this.func_174890_g()) {
            return this.partsGot[id - 1];
        }
        return 0;
    }

    public int func_174890_g() {
        return this.partsGot.length + 1;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        int i;
        super.func_189515_b(nbt);
        NBTTagList list = new NBTTagList();
        for (i = 0; i < this.partsGot.length; ++i) {
            list.func_74742_a((NBTBase)new NBTTagByte((byte)this.partsGot[i]));
        }
        nbt.func_74782_a("parts", (NBTBase)list);
        nbt.func_74768_a("age", this.age);
        nbt.func_74757_a("haswork", this.hasWork);
        nbt.func_74768_a("upgrade", this.installedUpgrade);
        nbt.func_74757_a("isCharged", this.isCharged);
        if (this.actualPartSide != null) {
            nbt.func_74768_a("actualPartSide", this.actualPartSide.ordinal());
        }
        for (i = 0; i < this.partSlots; ++i) {
            nbt.func_74778_a("part_" + i, this.partsNeeded[i].serializeNBT());
        }
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("parts")) {
            NBTTagList list = nbt.func_150295_c("parts", 1);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagByte tag = (NBTTagByte)list.func_179238_g(i);
                this.partsGot[i] = tag.func_150290_f();
            }
        }
        if (nbt.func_74764_b("age")) {
            this.age = nbt.func_74762_e("age");
        }
        if (nbt.func_74764_b("haswork")) {
            this.hasWork = nbt.func_74767_n("haswork");
        }
        if (nbt.func_74764_b("upgrade")) {
            this.installedUpgrade = nbt.func_74762_e("upgrade");
        }
        if (nbt.func_74764_b("isCharged")) {
            this.isCharged = nbt.func_74767_n("isCharged");
        }
        if (nbt.func_74764_b("actualPartSide")) {
            this.actualPartSide = EnumFacing.func_82600_a((int)nbt.func_74762_e("actualPartSide"));
        }
        for (int i = 0; i < this.partSlots; ++i) {
            if (!nbt.func_74764_b("part_" + i)) continue;
            this.partsNeeded[i].deserializeNBT(nbt.func_74779_i("part_" + i));
        }
    }

    protected void fillMachineParts() {
        MachinePart[] toCopy = FacTechConfigManager.allParts.get(this.getClass());
        for (int i = 0; i < toCopy.length; ++i) {
            this.partsNeeded[i] = new MachinePart(this, toCopy[i]);
        }
    }

    protected abstract boolean performAction();

    public abstract int getOpTime();

    @Override
    public void onInventoryChanged(int slot) {
        this.getHasWork();
    }

    protected EnumFacing getFront() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(StateList.directions);
    }

    private int hasPartInReserve(PartList part) {
        for (int i = this.inSlots; i < this.inSlots + this.partSlots; ++i) {
            ItemStack is = this.func_70301_a(i);
            if (is.func_77973_b() != ItemRegistry.machinePart || PartList.getPartFromDamage(is.func_77952_i()) != part) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<String> getGlassInfo() {
        ArrayList<String> list = new ArrayList<String>();
        String str = "Installed upgrade: ";
        switch (this.installedUpgrade) {
            case 1: {
                str = str + "Overclock";
                break;
            }
            case 2: {
                str = str + "Underclock";
                break;
            }
            case 3: {
                str = str + "Range";
                break;
            }
            case 4: {
                str = str + "Consistency";
                break;
            }
            case 5: {
                str = str + "Efficiency";
                break;
            }
            default: {
                str = str + "None";
            }
        }
        list.add(str);
        return list;
    }

    protected static enum RelativeSide {
        FRONT,
        BACK,
        SIDE,
        TOP,
        BOTTOM,
        ANY,
        NONE;

    }
}

