/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity;

import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.helper.Logger;
import dalapo.factech.helper.Pair;
import dalapo.factech.tileentity.TileEntityMachine;
import java.util.List;
import net.minecraft.item.ItemStack;

public abstract class TileEntityProcessorMultiOutput
extends TileEntityMachine {
    public TileEntityProcessorMultiOutput(String name, int partSlots, int outSlots) {
        super(name, 1, partSlots, outSlots);
    }

    public abstract List<MachineRecipes.MachineRecipe<ItemStack, ItemStack[]>> getRecipeList();

    @Override
    public boolean canRun() {
        return super.canRun() && this.hasWork;
    }

    @Override
    public void getHasWork() {
        Pair<Integer, ItemStack[]> data = this.getOutput(this.getInput(0));
        if (data == null) {
            this.hasWork = false;
            return;
        }
        ItemStack[] is = (ItemStack[])data.b;
        try {
            for (int i = 0; i < is.length; ++i) {
                if ((is[i].func_77969_a(this.getOutput(i)) || this.getOutput(i).func_190926_b()) && this.getInput().func_190916_E() >= (Integer)data.a && !is[i].func_190926_b() && is[i].func_190916_E() + this.getOutput(i).func_190916_E() < 64) continue;
                this.hasWork = false;
                return;
            }
            this.hasWork = true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logger.error(String.format("Machine %s attempted to output to a nonexistent slot: %s", this, e.getMessage()));
        }
    }

    @Override
    protected boolean performAction() {
        Pair<Integer, ItemStack[]> data = this.getOutput(this.getInput(0));
        ItemStack[] output = (ItemStack[])data.b;
        this.getInput(0).func_190918_g(((Integer)data.a).intValue());
        if (output.length > this.outputSlots) {
            Logger.error("Who the hell designed this thing?");
            return false;
        }
        for (int i = 0; i < output.length; ++i) {
            if (this.getOutput(i).func_190926_b()) {
                this.setOutput(i, output[i].func_77946_l());
                continue;
            }
            this.getOutput(i).func_190917_f(output[i].func_190916_E());
        }
        this.getHasWork();
        this.func_70296_d();
        return true;
    }

    protected Pair<Integer, ItemStack[]> getOutput(ItemStack is) {
        for (MachineRecipes.MachineRecipe<ItemStack, ItemStack[]> entry : this.getRecipeList()) {
            if (this.hasBadParts() && !entry.worksWithBad()) continue;
            ItemStack in = entry.input().func_77946_l();
            ItemStack[] out = new ItemStack[entry.output().length];
            if (!FacStackHelper.matchStacksWithWildcard(in, is) || in.func_190916_E() > is.func_190916_E()) continue;
            for (int i = 0; i < out.length; ++i) {
                out[i] = entry.output()[i].func_77946_l();
            }
            return new Pair<Integer, ItemStack[]>(entry.input().func_190916_E(), out);
        }
        return null;
    }
}

