/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity;

import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.tileentity.TileEntityBasicInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEntityRFGenerator
extends TileEntityBasicInventory
implements ITickable,
ISidedInventory {
    private int internalStorage;
    public IEnergyStorage buffer = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return TileEntityRFGenerator.this.internalStorage;
        }

        public int getMaxEnergyStored() {
            return TileEntityRFGenerator.this.getMaxStorage();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return false;
        }
    };

    public TileEntityRFGenerator(String name, int slots) {
        super(name, slots);
    }

    protected boolean doOutput(ItemStack out, int outSlot) {
        if (this.func_70301_a(outSlot).func_190926_b()) {
            this.func_70299_a(outSlot, out);
            return true;
        }
        if (FacStackHelper.canCombineStacks(this.func_70301_a(outSlot), out)) {
            this.func_70301_a(outSlot).func_190917_f(out.func_190916_E());
            return true;
        }
        return false;
    }

    protected void feedStorage(int amount) {
        this.internalStorage += Math.min(amount, this.getMaxStorage() - this.internalStorage);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.buffer);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return super.getCapability(capability, side);
        }
        return null;
    }

    public void func_73660_a() {
        int toTransfer = Math.min(this.getMaxTransfer(), this.internalStorage);
        this.internalStorage -= toTransfer;
        this.internalStorage += this.transferNRG(toTransfer);
    }

    protected abstract int getMaxTransfer();

    public abstract int getMaxStorage();

    private int transferNRG(int nrg) {
        for (EnumFacing side : this.getOutputSides()) {
            TileEntity te;
            BlockPos neighbour = FacMathHelper.withOffset(this.field_174879_c, side);
            if (!this.field_145850_b.func_175667_e(FacMathHelper.withOffset(this.field_174879_c, side)) || (te = this.field_145850_b.func_175625_s(neighbour)) == null) continue;
            IEnergyStorage storage = null;
            if (te.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d())) {
                storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
            } else if (te.hasCapability(CapabilityEnergy.ENERGY, null)) {
                storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
            }
            if (storage == null || (nrg -= storage.receiveEnergy(nrg, false)) > 0) continue;
            return 0;
        }
        return nrg;
    }

    protected EnumFacing[] getOutputSides() {
        return EnumFacing.field_82609_l;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("nrg", this.internalStorage);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.internalStorage = nbt.func_74762_e("nrg");
    }

    public int func_174887_a_(int id) {
        if (id == 0) {
            return this.internalStorage;
        }
        return 0;
    }

    @Override
    public int getMaxField(int id) {
        if (id == 0) {
            return this.buffer.getMaxEnergyStored();
        }
        return 0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }
}

