/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.automation;

import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacTileHelper;
import dalapo.factech.reference.StateList;
import dalapo.factech.tileentity.ActionOnRedstone;
import dalapo.factech.tileentity.TileEntityBasicInventory;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityBulkMover
extends TileEntityBasicInventory
implements ISidedInventory,
ActionOnRedstone {
    private boolean isPowered = false;
    public static final String id = "StackMover";
    private int filterSlot = 0;

    public TileEntityBulkMover() {
        super("bulkmover", 9);
    }

    @Override
    public void onRedstoneSignal(boolean isSignal, EnumFacing side) {
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            if (!this.isPowered && isSignal) {
                this.transferStacks();
                this.isPowered = true;
            }
        } else if (!isSignal) {
            this.isPowered = false;
        }
    }

    private int checkFilter(ItemStack is) {
        for (int i = 0; i < 9; ++i) {
            if (!this.func_70301_a(i).func_77969_a(is) || this.func_70301_a(i).func_190916_E() > is.func_190916_E()) continue;
            return i;
        }
        return -1;
    }

    private int[] getSlot(IItemHandler te, IItemHandler dest, int side, boolean insert) {
        if (te == null) {
            return null;
        }
        for (int i = 0; i < te.getSlots(); ++i) {
            ItemStack wouldMove;
            if (!insert && te.getStackInSlot(i).func_190926_b()) continue;
            int filterSlot = this.checkFilter(te.getStackInSlot(i));
            if (!FacTileHelper.isValidSlotForSide(te, side, i, !insert) || te.getStackInSlot(i).func_190926_b() || filterSlot == -1 || !FacTileHelper.hasSpaceForItem(dest, wouldMove = te.getStackInSlot(i), EnumFacing.func_82600_a((int)side).func_176734_d().ordinal(), true)) continue;
            return new int[]{filterSlot, i};
        }
        return null;
    }

    private void transferStacks() {
        IItemHandler push;
        EnumFacing front = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(StateList.directions);
        TileEntity pullLoc = this.field_145850_b.func_175625_s(FacMathHelper.withOffset(this.func_174877_v(), front));
        TileEntity pushLoc = this.field_145850_b.func_175625_s(FacMathHelper.withOffset(this.func_174877_v(), front.func_176734_d()));
        IItemHandler pull = pullLoc == null ? null : (IItemHandler)pullLoc.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, front.func_176734_d());
        IItemHandler iItemHandler = push = pushLoc == null ? null : (IItemHandler)pushLoc.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, front);
        if (pull == null) {
            boolean flag = false;
            AxisAlignedBB pullBB = new AxisAlignedBB(FacMathHelper.withOffset(this.field_174879_c, front));
            List carts = this.field_145850_b.func_72872_a(EntityMinecart.class, pullBB);
            Iterator iterator = carts.iterator();
            while (iterator.hasNext()) {
                EntityMinecart minecart = (EntityMinecart)iterator.next();
                if (!minecart.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, front.func_176734_d())) continue;
                pull = (IItemHandler)minecart.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, front.func_176734_d());
                flag = true;
                break;
            }
            if (!flag) {
                return;
            }
        }
        if (push == null) {
            AxisAlignedBB pushBB = new AxisAlignedBB(FacMathHelper.withOffset(this.field_174879_c, front.func_176734_d()));
            List carts = this.field_145850_b.func_72872_a(EntityMinecart.class, pushBB);
            for (EntityMinecart minecart : carts) {
                if (!minecart.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, front)) continue;
                push = (IItemHandler)minecart.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, front);
                break;
            }
        }
        block2: for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack is = this.func_70301_a(i);
            if (is.func_190926_b()) continue;
            for (int j = 0; j < pull.getSlots(); ++j) {
                ItemStack toMove = pull.extractItem(j, is.func_190916_E(), true);
                if (!toMove.func_77969_a(is)) continue;
                toMove = pull.extractItem(j, is.func_190916_E(), true);
                if (push != null && FacTileHelper.hasSpaceForItem(push, toMove, front, true)) {
                    int initCount = toMove.func_190916_E();
                    ItemStack remaining = FacTileHelper.tryInsertItem(push, toMove, front.ordinal());
                    pull.extractItem(j, initCount - remaining.func_190916_E(), false);
                    continue block2;
                }
                if (push != null) continue;
                pull.extractItem(j, is.func_190916_E(), false);
                BlockPos pos = FacMathHelper.withOffset(this.func_174877_v(), front.func_176734_d());
                EntityItem drop = new EntityItem(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, toMove);
                drop.field_70159_w = 0.0;
                drop.field_70181_x = 0.0;
                drop.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)drop);
                continue block2;
            }
        }
    }

    @Override
    public int func_70302_i_() {
        return 9;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public String func_70005_c_() {
        return "Filter";
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }
}

