/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.automation;

import dalapo.factech.block.BlockInventorySensor;
import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacTileHelper;
import dalapo.factech.reference.StateList;
import dalapo.factech.tileentity.TileEntityBasicInventory;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityInventorySensor
extends TileEntityBasicInventory {
    private boolean matchAll;
    private boolean exactly;
    private boolean useDamage;
    private IItemHandler attachedInventory;

    public TileEntityInventorySensor() {
        super("inventorysensor", 9);
    }

    public void onLoad() {
        super.onLoad();
    }

    @Override
    public void onInventoryChanged(int slot) {
        this.updateState();
    }

    public void updateState() {
        EnumFacing dir = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(StateList.directions);
        TileEntity adj = this.field_145850_b.func_175625_s(FacMathHelper.withOffset(this.field_174879_c, dir.func_176734_d()));
        this.attachedInventory = adj == null ? null : (IItemHandler)adj.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockInventorySensor.POWERED, (Comparable)Boolean.valueOf(this.meetsCriteria())));
        FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
    }

    public boolean meetsCriteria() {
        if (this.attachedInventory == null) {
            return false;
        }
        boolean matchesAny = false;
        boolean matchesAll = true;
        for (int i = 0; i < 9; ++i) {
            ItemStack current = this.func_70301_a(i);
            if (current.func_190926_b()) continue;
            int actualNumber = FacTileHelper.countItems((IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), is -> is.func_77969_a(current));
            int count = FacTileHelper.countItems(this.attachedInventory, current.func_77973_b(), this.useDamage ? current.func_77952_i() : Short.MAX_VALUE);
            if (this.exactly ? count == actualNumber : count >= actualNumber) {
                matchesAny = true;
                continue;
            }
            matchesAll = false;
        }
        return this.matchAll ? matchesAll : matchesAny;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("matchAll", this.matchAll);
        nbt.func_74757_a("exactly", this.exactly);
        nbt.func_74757_a("useDamage", this.useDamage);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.matchAll = nbt.func_74767_n("matchAll");
        this.exactly = nbt.func_74767_n("exactly");
        this.useDamage = nbt.func_74767_n("useDamage");
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.matchAll ? 1 : 0;
            }
            case 1: {
                return this.exactly ? 1 : 0;
            }
            case 2: {
                return this.useDamage ? 1 : 0;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        boolean val = value != 0;
        switch (id) {
            case 0: {
                this.matchAll = val;
                break;
            }
            case 1: {
                this.exactly = val;
                break;
            }
            case 2: {
                this.useDamage = val;
            }
        }
        this.updateState();
    }

    public int func_174890_g() {
        return 3;
    }
}

