/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.automation;

import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacTileHelper;
import dalapo.factech.reference.StateList;
import dalapo.factech.tileentity.TileEntityBasicInventory;
import dalapo.factech.tileentity.TileEntityItemQueue;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityItemPusher
extends TileEntityBasicInventory
implements ITickable {
    private boolean ignoreDamage;
    private int extension = 0;
    private int prevExt = 0;
    private int extDir = 1;
    public static final int EXTENSION_TICKS = 2;
    public int cooldown = 0;

    public TileEntityItemPusher() {
        super("pulsepiston", 9);
    }

    private boolean isFilterEmpty() {
        for (int i = 0; i < 9; ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private boolean isItemInFilter(ItemStack is) {
        for (int i = 0; i < 9; ++i) {
            if (!(this.ignoreDamage ? this.func_70301_a(i).func_185136_b(is) : this.func_70301_a(i).func_77969_a(is))) continue;
            return true;
        }
        return this.isFilterEmpty();
    }

    private void moveEntity(EntityItem ei, EnumFacing direction) {
        ei.field_70159_w = 0.0;
        ei.field_70181_x = 0.0;
        ei.field_70179_y = 0.0;
        switch (direction) {
            case SOUTH: {
                ei.field_70161_v += 1.0;
                break;
            }
            case WEST: {
                ei.field_70165_t -= 1.0;
                break;
            }
            case NORTH: {
                ei.field_70161_v -= 1.0;
                break;
            }
            case EAST: {
                ei.field_70165_t += 1.0;
                break;
            }
        }
    }

    private EntityItem getEntity(ItemStack is, EnumFacing direction) {
        switch (direction) {
            case SOUTH: {
                return new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 2.5, is);
            }
            case WEST: {
                return new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() - 2.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), is);
            }
            case NORTH: {
                return new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() - 2.5, is);
            }
            case EAST: {
                return new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 2.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), is);
            }
        }
        return new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), is);
    }

    private boolean pushEntities(EnumFacing direction) {
        boolean hasPushed = false;
        AxisAlignedBB testBox = new AxisAlignedBB(FacMathHelper.withOffset(this.func_174877_v(), direction));
        List entities = this.field_145850_b.func_72872_a(EntityItem.class, testBox);
        if (entities.isEmpty()) {
            return false;
        }
        BlockPos targetSpace = FacMathHelper.withOffsetAndDist(this.field_174879_c, direction, 2);
        TileEntity te = this.field_145850_b.func_175625_s(targetSpace);
        for (EntityItem ei : entities) {
            ItemStack is = ei.func_92059_d();
            if (!this.isItemInFilter(is)) continue;
            hasPushed = true;
            if (!this.field_145850_b.field_72995_K && te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d())) {
                IItemHandler inventory = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d());
                ItemStack remaining = FacTileHelper.tryInsertItem(inventory, is, direction.func_176734_d().ordinal());
                if (remaining.func_190926_b()) {
                    ei.func_70106_y();
                    continue;
                }
                ei.func_92058_a(remaining);
                continue;
            }
            this.moveEntity(ei, direction);
        }
        return hasPushed;
    }

    private boolean pushQueue(TileEntityItemQueue te, EnumFacing direction) {
        ItemStack is = te.peek(te.getCapacity() / 2);
        boolean hasPushed = false;
        if (!is.func_190926_b() && this.isItemInFilter(is)) {
            hasPushed = true;
            BlockPos targetSpace = new BlockPos((Vec3i)FacMathHelper.withOffsetAndDist(this.field_174879_c, direction, 2));
            TileEntity dest = this.field_145850_b.func_175625_s(targetSpace);
            if (!this.field_145850_b.field_72995_K) {
                if (dest != null && dest.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d())) {
                    IItemHandler inventory = (IItemHandler)dest.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d());
                    ItemStack remaining = FacTileHelper.tryInsertItem(inventory, is, direction.func_176734_d().ordinal());
                    if (remaining.func_190926_b()) {
                        te.yank(te.getCapacity() / 2);
                    } else {
                        te.set(te.getCapacity() / 2, remaining);
                    }
                } else if (dest instanceof TileEntityItemQueue) {
                    TileEntityItemQueue queue = (TileEntityItemQueue)dest;
                    is = te.yank(te.getCapacity() / 2);
                    queue.scheduleItemStack(is);
                } else {
                    is = te.yank(te.getCapacity() / 2);
                    EntityItem ei = this.getEntity(is, direction);
                    ei.field_70159_w = 0.0;
                    ei.field_70181_x = 0.0;
                    ei.field_70179_y = 0.0;
                    this.field_145850_b.func_72838_d((Entity)ei);
                }
            }
        }
        FacBlockHelper.updateBlock(this.field_145850_b, te.func_174877_v());
        return hasPushed;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
            return;
        }
        EnumFacing direction = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(StateList.directions);
        TileEntity te = this.field_145850_b.func_175625_s(FacMathHelper.withOffset(this.field_174879_c, direction));
        boolean hasPushed = false;
        hasPushed = te instanceof TileEntityItemQueue ? this.pushQueue((TileEntityItemQueue)te, direction) : this.pushEntities(direction);
        if (this.field_145850_b.field_72995_K) {
            this.extension += this.extDir;
            if (this.extension == 2) {
                this.extDir = -1;
            } else if (this.extension == 0 && this.extDir != 0) {
                this.cooldown = 5;
                this.extDir = 0;
            }
            this.prevExt = this.extension;
            if (this.extension == 0 && this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.cooldown == 0 && this.extension == 0 && hasPushed) {
                this.extDir = 1;
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("ignoreDamage", this.ignoreDamage);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ignoreDamage = nbt.func_74767_n("ignoreDamage");
    }

    public int func_174887_a_(int id) {
        if (id == 0) {
            return this.ignoreDamage ? 1 : 0;
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.ignoreDamage = value != 0;
            }
        }
    }

    public int func_174890_g() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public double getExtendedLength() {
        return this.extension;
    }

    @SideOnly(value=Side.CLIENT)
    public double getExtendedDir() {
        return this.extDir;
    }

    static {
        isReversed = true;
    }
}

