/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.automation;

import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacTileHelper;
import dalapo.factech.helper.Logger;
import dalapo.factech.tileentity.TileEntityBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityItemRedis
extends TileEntityBase {
    private static final EnumFacing[] directionsMinusUp = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    private boolean splitStacks;
    private int next = 0;
    private int[] ratios = new int[]{1, 1, 1, 1, 1};

    public TileEntityItemRedis() {
        super("itemredis");
    }

    private int getSide(int n) {
        if (n > FacMathHelper.sum(this.ratios)) {
            return 0;
        }
        int count = 0;
        int i = 0;
        for (i = 0; i < 5 && (count += this.ratios[i]) <= n; ++i) {
        }
        if (!FacMathHelper.isInRange(i, 0, 5)) {
            return 0;
        }
        return i;
    }

    public boolean shouldSplit() {
        return this.splitStacks;
    }

    public int getRatio(int side) {
        if (FacMathHelper.isInRange(side, 0, 5)) {
            return this.ratios[side];
        }
        return -1;
    }

    public void setRatio(int side, int val) {
        if (FacMathHelper.isInRange(side, 0, 5) && val >= 0) {
            this.ratios[side] = val;
        }
    }

    public void changeRatio(int side, int val) {
        if (FacMathHelper.isInRange(side, 0, 5) && this.ratios[side] + val >= 0) {
            int n = side;
            this.ratios[n] = this.ratios[n] + val;
        }
    }

    public void toggleSplit() {
        this.splitStacks = !this.splitStacks;
    }

    public void redistributeItems(ItemStack in) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.splitStacks) {
            ItemStack[] stacks = new ItemStack[5];
            for (int i = 0; i < 5; ++i) {
                stacks[i] = new ItemStack(in.func_77973_b(), 0, in.func_77952_i());
            }
            for (int itemsRemaining = in.func_190916_E(); itemsRemaining > 0; --itemsRemaining) {
                stacks[this.getSide(this.next++)].func_190917_f(1);
                if (this.next != FacMathHelper.sum(this.ratios)) continue;
                this.next = 0;
            }
            for (int i = 0; i < 6; ++i) {
                if (i == 1) continue;
                EnumFacing dir = EnumFacing.func_82600_a((int)i);
                ItemStack stack = stacks[i == 0 ? i : i - 1];
                if (stack.func_190916_E() == 0) continue;
                stack.func_77982_d(in.func_77978_p());
                BlockPos pos = FacMathHelper.withOffset(this.func_174877_v(), dir);
                TileEntity dest = this.field_145850_b.func_175625_s(pos);
                Logger.info(dest == null);
                if (dest != null && dest.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d())) {
                    IItemHandler inv = (IItemHandler)dest.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d());
                    stack = FacTileHelper.tryInsertItem(inv, stack, EnumFacing.func_82600_a((int)(i == 0 ? i : i - 1)).func_176734_d().func_176745_a());
                }
                if (stack.func_190926_b()) continue;
                EntityItem ei = new EntityItem(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, i == 0 ? stacks[i] : stacks[i - 1]);
                ei.field_70159_w = 0.0;
                ei.field_70181_x = 0.0;
                ei.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)ei);
            }
        } else {
            Logger.info("Next: " + this.next);
            EnumFacing dir = directionsMinusUp[this.getSide(this.next++)];
            BlockPos pos = FacMathHelper.withOffset(this.func_174877_v(), dir);
            if (this.next >= FacMathHelper.sum(this.ratios)) {
                this.next = 0;
            }
            EntityItem ei = new EntityItem(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, in);
            ei.field_70159_w = 0.0;
            ei.field_70181_x = 0.0;
            ei.field_70179_y = 0.0;
            this.field_145850_b.func_72838_d((Entity)ei);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        String[] dirs = new String[]{"down", "north", "south", "west", "east"};
        for (int i = 0; i < 5; ++i) {
            nbt.func_74768_a(dirs[i], this.ratios[i]);
        }
        nbt.func_74768_a("next", this.next);
        nbt.func_74757_a("split", this.splitStacks);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        String[] dirs = new String[]{"down", "north", "south", "west", "east"};
        for (int i = 0; i < 5; ++i) {
            this.ratios[i] = nbt.func_74762_e(dirs[i]);
        }
        this.next = nbt.func_74762_e("next");
        this.splitStacks = nbt.func_74767_n("split");
    }
}

