/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.automation;

import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.Logger;
import dalapo.factech.init.BlockRegistry;
import dalapo.factech.reference.StateList;
import dalapo.factech.tileentity.IMagnifyingGlassInfo;
import dalapo.factech.tileentity.TileEntityBase;
import dalapo.factech.tileentity.TileEntityMachine;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEntityPartSensor
extends TileEntityBase
implements ITickable,
IMagnifyingGlassInfo {
    private boolean hasFullyLoaded = false;
    private TileEntityPartSensor behind;
    private TileEntityMachine watchingMachine;
    private int watchingSlot = 0;
    private int output = 0;

    public TileEntityPartSensor() {
        super("partsensor");
    }

    private void init(int slot, @Nullable TileEntityMachine machine) {
        this.watchingMachine = machine;
        this.watchingSlot = slot;
        TileEntity te = this.field_145850_b.func_175625_s(FacMathHelper.withOffset(this.field_174879_c, this.direction.func_176734_d()));
        if (te instanceof TileEntityPartSensor && ((TileEntityPartSensor)te).direction.equals((Object)this.direction)) {
            this.behind = (TileEntityPartSensor)te;
            this.behind.init(slot + 1, machine);
        }
    }

    public void onLoad() {
        this.setDirection((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(StateList.directions));
    }

    private TileEntityMachine getMachine() {
        return this.watchingMachine;
    }

    public void func_73660_a() {
        int newOutput;
        TileEntity te = this.field_145850_b.func_175625_s(FacMathHelper.withOffset(this.field_174879_c, this.direction));
        if (te == null && this.watchingMachine != null) {
            this.init(0, null);
        } else if (te instanceof TileEntityMachine && (TileEntityMachine)te != this.watchingMachine) {
            this.init(0, (TileEntityMachine)te);
        }
        int n = newOutput = this.getMachine() == null || this.getMachine().hasPart(this.watchingSlot) ? 0 : 15;
        if (newOutput != this.output) {
            this.output = newOutput;
            Logger.info(String.format("Slot %s: changing state", this.watchingSlot));
            FacBlockHelper.updateNeighbours(this.field_145850_b, this.field_174879_c, BlockRegistry.partSensor);
        }
    }

    @Override
    public int getComparatorOverride() {
        return this.output;
    }

    @Override
    public List<String> getGlassInfo() {
        ArrayList<String> info = new ArrayList<String>();
        if (this.getMachine() == null) {
            info.add("Not watching machine");
        } else {
            info.add(String.format("Watching machine %s, part slot %s", this.getMachine().getName(), this.watchingSlot));
        }
        return info;
    }
}

