/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.automation;

import dalapo.factech.auxiliary.IHasFluid;
import dalapo.factech.auxiliary.IInfoPacket;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacMiscHelper;
import dalapo.factech.packet.FluidInfoPacket;
import dalapo.factech.packet.PacketHandler;
import dalapo.factech.tileentity.IMagnifyingGlassInfo;
import dalapo.factech.tileentity.TileFTFluidHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityPipe
extends TileFTFluidHandler
implements ITickable,
IInfoPacket,
IHasFluid,
IMagnifyingGlassInfo {
    protected int flow;
    protected EnumFacing prevFilled;

    public TileEntityPipe(String name, int flow, int cap) {
        super(name);
        this.flow = flow;
        this.tank.setCapacity(cap);
        this.tank.setCanFill(false);
    }

    public TileEntityPipe() {
        this("pipe", 50, 200);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        return this.func_189515_b(nbt);
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbt);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int insertFluid(Fluid type, int amount, boolean doFill) {
        return this.insertFluid(new FluidStack(type, amount), doFill);
    }

    public int insertFluid(FluidStack fs, boolean doFill) {
        return this.tank.fillInternal(fs, doFill);
    }

    public void propagateFluid() {
        TileEntity te;
        if (this.tank.getFluidAmount() == 0) {
            return;
        }
        int numConnected = 0;
        for (EnumFacing f : EnumFacing.field_82609_l) {
            te = this.field_145850_b.func_175625_s(FacMathHelper.withOffset(this.func_174877_v(), f));
            if (te == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d())) continue;
            ++numConnected;
        }
        if (numConnected == 0) {
            return;
        }
        for (EnumFacing f : EnumFacing.field_82609_l) {
            if (f == this.prevFilled || (te = this.field_145850_b.func_175625_s(FacMathHelper.withOffset(this.func_174877_v(), f))) == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d())) continue;
            IFluidHandler tank = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d());
            FluidStack toTransfer = this.tank.drain(this.flow / numConnected, false);
            int filled = 0;
            if (toTransfer == null) {
                return;
            }
            if (te instanceof TileEntityPipe) {
                filled = ((TileEntityPipe)te).insertFluid(toTransfer, true);
                ((TileEntityPipe)te).prevFilled = f.func_176734_d();
            } else {
                filled = tank.fill(toTransfer, true);
            }
            this.tank.drain(filled, true);
            te.func_70296_d();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        this.tank.writeToNBT(nbt);
        nbt.func_74768_a("flow", this.flow);
        if (this.prevFilled == null) {
            nbt.func_74768_a("direction", -1);
        } else {
            nbt.func_74768_a("direction", this.prevFilled.ordinal());
        }
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt);
        this.flow = nbt.func_74762_e("flow");
        int i = nbt.func_74762_e("direction");
        this.prevFilled = i == -1 ? null : EnumFacing.func_82600_a((int)i);
    }

    public void func_73660_a() {
        this.propagateFluid();
    }

    @Override
    public void sendInfoPacket(EntityPlayer ep) {
        PacketHandler.sendToPlayer(new FluidInfoPacket(this.func_174877_v(), new FluidTank[]{this.tank}, 1), (EntityPlayer)((EntityPlayerMP)ep));
    }

    @Override
    public FluidTank getTank(int tank) {
        return this.tank;
    }

    @Override
    public void overrideTank(FluidStack fs, int tank) {
        this.tank.setFluid(fs);
    }

    @Override
    public List<String> getGlassInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(FacMiscHelper.describeTank(this.tank));
        return info;
    }
}

