/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.automation;

import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacMiscHelper;
import dalapo.factech.reference.StateList;
import dalapo.factech.tileentity.automation.TileEntityPipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class TileEntityPipeValve
extends TileEntityPipe {
    public static final int MAX_FLOW = 50;
    private Fluid filter;
    private int flowLimit = 0;
    private EnumFacing inputDirection;
    private boolean redstoneControlled = false;

    public int getFlow() {
        return Math.min(this.flowLimit, 50);
    }

    public void onLoad() {
        super.onLoad();
        this.inputDirection = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(StateList.directions);
    }

    @Override
    public int insertFluid(@Nonnull FluidStack toTransfer, boolean doFill) {
        if (this.filter == null || this.filter.equals(toTransfer.getFluid())) {
            return this.tank.fillInternal(toTransfer, doFill);
        }
        return 0;
    }

    @Override
    public void propagateFluid() {
        EnumFacing outputDirection;
        if (this.inputDirection == null) {
            this.inputDirection = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(StateList.directions);
        }
        this.prevFilled = outputDirection = this.inputDirection.func_176734_d();
        if (this.tank.getFluidAmount() == 0 || this.redstoneControlled && this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
            return;
        }
        TileEntity te = this.field_145850_b.func_175625_s(FacMathHelper.withOffset(this.func_174877_v(), outputDirection));
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.inputDirection)) {
            IFluidHandler tank = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.inputDirection);
            FluidStack toTransfer = this.tank.drain(this.getFlow(), false);
            int filled = 0;
            if (toTransfer == null) {
                return;
            }
            if (te instanceof TileEntityPipe) {
                filled = ((TileEntityPipe)te).insertFluid(toTransfer, true);
                ((TileEntityPipe)te).prevFilled = this.inputDirection;
            } else {
                filled = tank.fill(toTransfer, true);
            }
            this.tank.drain(filled, true);
            te.func_70296_d();
        }
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == this.inputDirection || facing == this.inputDirection.func_176734_d());
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == this.inputDirection || facing == this.inputDirection.func_176734_d()) {
            return (T)this.tank;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean onRightClick(EntityPlayer ep, EnumFacing dir, ItemStack held) {
        IFluidHandlerItem handler = (IFluidHandlerItem)held.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (handler != null) {
            FluidStack fs = handler.getTankProperties()[0].getContents();
            this.filter = fs == null || fs.getFluid() == null ? null : fs.getFluid();
            return true;
        }
        return false;
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.flowLimit;
            }
            case 1: {
                return this.redstoneControlled ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int num) {
        switch (id) {
            case 0: {
                this.flowLimit = (int)FacMathHelper.clamp(num, 0.0, 50.0);
            }
            case 1: {
                this.redstoneControlled = num != 0;
            }
        }
    }

    @Override
    public List<String> getGlassInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(FacMiscHelper.describeTank(this.tank));
        info.add(String.format("Flow limit: %s", Math.min(this.flowLimit, 50)));
        info.add(this.filter == null ? "No filter" : String.format("Only allowing %s", this.filter.getLocalizedName(null)));
        return info;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("flowLimit", this.flowLimit);
        nbt.func_74757_a("redstone", this.redstoneControlled);
        nbt.func_74778_a("filter", this.filter == null ? "[none]" : this.filter.getName());
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.flowLimit = nbt.func_74762_e("flowLimit");
        this.redstoneControlled = nbt.func_74767_n("redstone");
        String f = nbt.func_74779_i("filter");
        this.filter = f == null || f.equals("[none]") ? null : FluidRegistry.getFluid((String)f);
    }
}

