/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.automation;

import dalapo.factech.auxiliary.ChunkLoadRegistry;
import dalapo.factech.auxiliary.ChunkWithDimension;
import dalapo.factech.auxiliary.IChunkLoader;
import dalapo.factech.auxiliary.PosWithDimension;
import dalapo.factech.config.FacTechConfigManager;
import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.helper.FacEntityHelper;
import dalapo.factech.tileentity.ActionOnRedstone;
import dalapo.factech.tileentity.IMagnifyingGlassInfo;
import dalapo.factech.tileentity.TileEntityBasicInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPlaneShifter
extends TileEntityBasicInventory
implements IMagnifyingGlassInfo,
ISidedInventory,
IChunkLoader,
ITickable,
ActionOnRedstone {
    private static final boolean actuallyLoadChunks = true;
    private int dimensionID;
    private int chorusStorage;
    private boolean loaded;
    private boolean isPowered;
    private List<ChunkWithDimension> cache = new ArrayList<ChunkWithDimension>();
    private PosWithDimension dimPos;
    @SideOnly(value=Side.CLIENT)
    public float ticks;
    public static final float dt = 0.1f;

    public TileEntityPlaneShifter() {
        super("planeshifter", 10);
    }

    public void shiftItems() {
        WorldServer dimension = this.field_145850_b.func_73046_m().func_71218_a(this.dimensionID);
        int acc = 0;
        for (int i = 0; i < 9; ++i) {
            acc += this.func_70301_a(i).func_190916_E();
        }
        int chorusRequired = (int)Math.ceil((double)acc / (double)FacTechConfigManager.itemsPerFruit);
        this.chorusStorage -= Math.min(this.chorusStorage, chorusRequired);
        if (this.chorusStorage >= chorusRequired) {
            for (int i = 0; i < 9; ++i) {
                ItemStack is = this.func_70301_a(i);
                EntityItem ei = new EntityItem((World)dimension, (double)this.dimPos.func_177958_n() + 0.5, (double)this.dimPos.func_177958_n() + 0.5, (double)this.dimPos.func_177952_p() + 0.5, is);
                FacEntityHelper.stopEntity((Entity)ei);
                dimension.func_72838_d((Entity)ei);
                this.func_70299_a(i, ItemStack.field_190927_a);
            }
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else {
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
    }

    private void getDimensionPos() {
        if (this.field_145850_b instanceof WorldServer) {
            double ratio = this.field_145850_b.field_73011_w.getMovementFactor() / this.field_145850_b.func_73046_m().func_71218_a((int)this.dimensionID).field_73011_w.getMovementFactor();
            this.dimPos = new PosWithDimension(this.field_145850_b.func_73046_m().func_71218_a(this.dimensionID), this.dimensionID, (double)this.field_174879_c.func_177958_n() * ratio, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() * ratio);
        }
    }

    @Override
    public void onInventoryChanged(int slot) {
        if (slot == 9 && this.func_70301_a(9).func_77973_b() == Items.field_185162_cT) {
            int toFill = Math.min(this.func_70301_a(9).func_190916_E(), 256 - this.chorusStorage);
            this.chorusStorage += toFill;
            this.func_70301_a(9).func_190918_g(toFill);
        }
        FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.ticks += 0.1f;
        }
        if (!this.loaded && !this.field_145850_b.field_72995_K) {
            this.loaded = true;
            this.getDimensionPos();
            ChunkLoadRegistry.instance.loadChunks(this.dimPos, this.getChunksToLoad());
        }
    }

    public void func_145843_s() {
        ChunkLoadRegistry.instance.unloadChunks(this.dimPos);
    }

    public void changeDimension(int newDim) {
        ChunkLoadRegistry.instance.unloadChunks(this.dimPos);
        this.dimensionID = newDim;
        this.getDimensionPos();
        this.loaded = false;
    }

    @Override
    public List<ChunkWithDimension> getChunksToLoad() {
        if (this.dimPos == null) {
            return new ArrayList<ChunkWithDimension>();
        }
        if (this.cache.isEmpty()) {
            double thisMovement = this.field_145850_b.field_73011_w.getMovementFactor();
            double otherMovement = this.field_145850_b.func_73046_m().func_71218_a((int)this.dimensionID).field_73011_w.getMovementFactor();
            double factor = thisMovement / otherMovement;
            Chunk chunk = this.field_145850_b.func_175726_f((BlockPos)this.dimPos);
            this.cache.add(new ChunkWithDimension(this.dimensionID, chunk.field_76635_g, chunk.field_76647_h));
        }
        return this.cache;
    }

    public int getDimension() {
        return this.dimensionID;
    }

    @Override
    public void onRedstoneSignal(boolean isSignal, EnumFacing side) {
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            if (!this.isPowered && isSignal) {
                this.isPowered = true;
                this.shiftItems();
            }
        } else if (!isSignal) {
            this.isPowered = false;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("chorus", this.chorusStorage);
        nbt.func_74768_a("dimension", this.dimensionID);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.chorusStorage = nbt.func_74762_e("chorus");
        this.dimensionID = nbt.func_74762_e("dimension");
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{9};
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return direction != EnumFacing.DOWN || index == 9 && itemStackIn.func_77973_b() == Items.field_185162_cT;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public int func_174887_a_(int id) {
        if (id == 0) {
            return this.chorusStorage;
        }
        if (id == 1) {
            return this.dimensionID;
        }
        return 0;
    }

    public void func_174885_b(int id, int val) {
        if (id == 0) {
            this.chorusStorage = val;
        }
        if (id == 1) {
            this.dimensionID = val;
        }
    }

    @Override
    public int getMaxField(int id) {
        if (id == 0) {
            return 256;
        }
        return Integer.MAX_VALUE;
    }

    public PosWithDimension getDimPos() {
        return this.dimPos;
    }

    @Override
    public List<String> getGlassInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Attuned dimension: " + this.dimensionID);
        return info;
    }
}

