/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.automation;

import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.reference.StateList;
import dalapo.factech.tileentity.ActionOnRedstone;
import dalapo.factech.tileentity.TileEntityBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEntityPulser
extends TileEntityBase
implements ActionOnRedstone,
ITickable {
    private boolean isPulsing;
    private boolean isPowered;
    private int remainingPulses;
    private int remainingWait;
    private boolean currentState;
    private int ticksPer = 1;
    private int ticksBetween = 1;
    private int numPulses = 1;

    public TileEntityPulser() {
        super("pulser");
    }

    @Override
    public void onRedstoneSignal(boolean isSignal, EnumFacing side) {
        if (this.field_145850_b.func_175640_z(this.field_174879_c) && side == ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(StateList.directions)).func_176734_d() && !this.isPulsing) {
            if (!this.isPowered && isSignal) {
                this.beginPulseSequence();
                this.isPowered = true;
            }
        } else if (!isSignal) {
            this.isPowered = false;
        }
    }

    public void onLoad() {
        super.onLoad();
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)StateList.powered, (Comparable)Boolean.valueOf(this.currentState)));
    }

    public void func_73660_a() {
        if (this.isPulsing) {
            if (this.remainingWait-- == 0) {
                this.remainingWait = 2 * this.togglePulse();
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)StateList.powered, (Comparable)Boolean.valueOf(this.currentState)));
                FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
            }
            if (this.remainingPulses == 0) {
                this.isPulsing = false;
            }
        }
    }

    private int togglePulse() {
        if (this.currentState) {
            --this.remainingPulses;
        }
        this.currentState = !this.currentState;
        return this.currentState ? this.ticksPer : this.ticksBetween;
    }

    public int getOutputPower() {
        return this.currentState ? 15 : 0;
    }

    private void beginPulseSequence() {
        this.remainingPulses = this.numPulses;
        this.isPulsing = true;
    }

    public boolean getIsPowered() {
        return this.isPowered;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("isPulsing", this.isPulsing);
        nbt.func_74757_a("isPowered", this.isPowered);
        nbt.func_74768_a("remainingPulses", this.remainingPulses);
        nbt.func_74768_a("remainingWait", this.remainingWait);
        nbt.func_74757_a("currentState", this.currentState);
        nbt.func_74768_a("ticksOn", this.ticksPer);
        nbt.func_74768_a("ticksOff", this.ticksBetween);
        nbt.func_74768_a("numPulses", this.numPulses);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isPulsing = nbt.func_74767_n("isPulsing");
        this.isPowered = nbt.func_74767_n("isPowered");
        this.remainingPulses = nbt.func_74762_e("remainingPulses");
        this.remainingWait = nbt.func_74762_e("remainingWait");
        this.currentState = nbt.func_74767_n("currentState");
        this.ticksPer = nbt.func_74762_e("ticksOn");
        this.ticksBetween = nbt.func_74762_e("ticksOff");
        this.numPulses = nbt.func_74762_e("numPulses");
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.numPulses;
            }
            case 1: {
                return this.ticksPer;
            }
            case 2: {
                return this.ticksBetween;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int val) {
        switch (id) {
            case 0: {
                this.numPulses = val;
                break;
            }
            case 1: {
                this.ticksPer = val;
                break;
            }
            case 2: {
                this.ticksBetween = val;
            }
        }
        this.func_70296_d();
    }

    @Override
    public int getFieldCount() {
        return 3;
    }
}

