/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.automation;

import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.helper.FacMiscHelper;
import dalapo.factech.init.BlockRegistry;
import dalapo.factech.tileentity.IMagnifyingGlassInfo;
import dalapo.factech.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileEntityRemoteComparator
extends TileEntityBase
implements IMagnifyingGlassInfo,
ITickable {
    private BlockPos link;
    private int currentPowerOutput;
    private boolean updateScheduled;

    public TileEntityRemoteComparator() {
        super("remotecomparator");
    }

    public void setLinkedPos(BlockPos bp) {
        this.link = bp;
        FacBlockHelper.updateBlock(this.field_145850_b, bp);
    }

    public BlockPos getLinkedPos() {
        return this.link;
    }

    public int getPowerOutput() {
        return this.currentPowerOutput;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.link != null) {
            nbt.func_74772_a("pos", this.link.func_177986_g());
        }
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("pos")) {
            this.link = BlockPos.func_177969_a((long)nbt.func_74763_f("pos"));
        }
    }

    @Override
    public List<String> getGlassInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Watching position:");
        info.add(this.link == null ? "None" : FacMiscHelper.describeBlockPos(this.link));
        return info;
    }

    public void func_73660_a() {
        IBlockState state;
        int output;
        if (this.link != null && (output = (state = this.field_145850_b.func_180495_p(this.link)).func_185888_a(this.field_145850_b, this.link)) != this.currentPowerOutput) {
            this.currentPowerOutput = output;
            this.updateScheduled = true;
        }
        if (this.updateScheduled) {
            FacBlockHelper.updateNeighbours(this.field_145850_b, this.field_174879_c, BlockRegistry.remoteComparator);
        }
    }
}

