/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.automation;

import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacTileHelper;
import dalapo.factech.reference.StateList;
import dalapo.factech.tileentity.ActionOnRedstone;
import dalapo.factech.tileentity.TileEntityBase;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityStackMover
extends TileEntityBase
implements ActionOnRedstone {
    private boolean isPowered = false;
    public static final String id = "StackMover";

    public TileEntityStackMover() {
        super("stackmover");
    }

    @Override
    public void onRedstoneSignal(boolean isSignal, EnumFacing side) {
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            if (!this.isPowered && isSignal) {
                this.transferStack();
                this.isPowered = true;
            }
        } else if (!isSignal) {
            this.isPowered = false;
        }
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TextComponentString("Filter");
    }

    private int getSlotToExtract(IItemHandler te, IItemHandler dest, int side) {
        if (te == null) {
            return -1;
        }
        for (int i = 0; i < te.getSlots(); ++i) {
            ItemStack wouldMove;
            if (te.getStackInSlot(i).func_190926_b() || !FacTileHelper.isValidSlotForSide(te, side, i, true) || te.getStackInSlot(i).func_190926_b() || !FacTileHelper.hasSpaceForItem(dest, wouldMove = te.getStackInSlot(i), EnumFacing.func_82600_a((int)side).func_176734_d().ordinal(), true)) continue;
            return i;
        }
        return -1;
    }

    private void transferStack() {
        int slot;
        IItemHandler push;
        EnumFacing front = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(StateList.directions);
        TileEntity pullLoc = this.field_145850_b.func_175625_s(FacMathHelper.withOffset(this.func_174877_v(), front));
        TileEntity pushLoc = this.field_145850_b.func_175625_s(FacMathHelper.withOffset(this.func_174877_v(), front.func_176734_d()));
        IItemHandler pull = pullLoc == null ? null : (IItemHandler)pullLoc.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, front.func_176734_d());
        IItemHandler iItemHandler = push = pushLoc == null ? null : (IItemHandler)pushLoc.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, front);
        if (pull == null) {
            boolean flag = false;
            AxisAlignedBB pullBB = new AxisAlignedBB(FacMathHelper.withOffset(this.field_174879_c, front));
            List carts = this.field_145850_b.func_72872_a(EntityMinecart.class, pullBB);
            for (EntityMinecart minecart : carts) {
                if (!minecart.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, front.func_176734_d())) continue;
                pull = (IItemHandler)minecart.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, front.func_176734_d());
                flag = true;
                break;
            }
            if (!flag) {
                return;
            }
        }
        if ((slot = this.getSlotToExtract(pull, push, front.func_176734_d().ordinal())) == -1) {
            return;
        }
        ItemStack toMove = pull.extractItem(slot, 64, true);
        if (push == null) {
            AxisAlignedBB pushBB = new AxisAlignedBB(FacMathHelper.withOffset(this.field_174879_c, front.func_176734_d()));
            List carts = this.field_145850_b.func_72872_a(EntityMinecart.class, pushBB);
            for (EntityMinecart minecart : carts) {
                if (!minecart.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, front)) continue;
                push = (IItemHandler)minecart.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, front);
                break;
            }
        }
        if (push == null) {
            BlockPos pos = FacMathHelper.withOffset(this.func_174877_v(), front.func_176734_d());
            pull.extractItem(slot, 64, false);
            EntityItem drop = new EntityItem(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, toMove);
            drop.field_70159_w = 0.0;
            drop.field_70181_x = 0.0;
            drop.field_70179_y = 0.0;
            this.field_145850_b.func_72838_d((Entity)drop);
        } else {
            int initCount = toMove.func_190916_E();
            ItemStack remaining = FacTileHelper.tryInsertItem(push, toMove, front.ordinal());
            pull.extractItem(slot, initCount - remaining.func_190916_E(), false);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }
}

