/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.automation;

import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.tileentity.IMagnifyingGlassInfo;
import dalapo.factech.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityTank
extends TileEntityBase
implements ITickable,
IMagnifyingGlassInfo {
    private FluidTank tank = new FluidTank(24000);

    public TileEntityTank() {
        super("tank");
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
        this.tank.setTileEntity((TileEntity)this);
    }

    public FluidStack getTankContents() {
        return this.tank.getFluid();
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.tank.getFluid() == null) {
            nbt.func_74778_a("name", "[empty]");
            nbt.func_74768_a("amount", 0);
        } else {
            nbt.func_74778_a("name", FluidRegistry.getFluidName((FluidStack)this.tank.getFluid()));
            nbt.func_74768_a("amount", this.tank.getFluidAmount());
        }
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("name") && nbt.func_74764_b("amount") && !nbt.func_74779_i("name").equals("[empty]")) {
            this.tank.setFluid(new FluidStack(FluidRegistry.getFluid((String)nbt.func_74779_i("name")), nbt.func_74762_e("amount")));
        } else if (nbt.func_74779_i("name").equals("[empty]")) {
            this.tank.setFluid(null);
        }
    }

    public void func_73660_a() {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (te instanceof TileEntityTank && this.field_145850_b.func_175687_A(this.field_174879_c) == 0) {
            TileEntityTank otherTank = (TileEntityTank)te;
            int toFill = FacMathHelper.getMin(24000 - otherTank.tank.getFluidAmount(), 100);
            if (toFill != 0 && this.tank.getFluidAmount() > 0 && FacStackHelper.canCombineFluids(this.tank.getFluid(), otherTank.tank.getFluid())) {
                otherTank.tank.fill(this.tank.drain(toFill, true), true);
            }
        }
    }

    @Override
    public List<String> getGlassInfo() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.tank.getFluid() == null) {
            list.add("Empty");
        } else {
            list.add(String.format("%s / %s mB of %s", this.tank.getFluidAmount(), this.tank.getCapacity(), this.tank.getFluid().getFluid().getLocalizedName(null)));
        }
        return list;
    }
}

