/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.automation;

import dalapo.factech.config.FacTechConfigManager;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.tileentity.TileEntityBase;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityWaterCollector
extends TileEntityBase
implements ITickable {
    private FluidTank tank = new FluidTank(1000);
    private Biome curBiome;
    private boolean hasWater;

    public TileEntityWaterCollector() {
        super("watercollector");
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(false);
    }

    private boolean isTouchingWater() {
        for (int i = 0; i < 6; ++i) {
            if (!this.field_145850_b.func_180495_p(FacMathHelper.withOffset(this.field_174879_c, EnumFacing.func_82600_a((int)i))).func_177230_c().equals(Blocks.field_150355_j)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onNeighbourChange(BlockPos changed) {
        this.hasWater = this.isTouchingWater();
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing dir) {
        return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing dir) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(cap, dir);
    }

    public void func_73660_a() {
        if (this.curBiome == null) {
            this.curBiome = this.field_145850_b.func_180494_b(this.field_174879_c);
        }
        if (!FacTechConfigManager.restrictWaterCollectorBiomes || this.curBiome.equals(Biomes.field_76771_b) || this.curBiome.equals(Biomes.field_150575_M) || this.curBiome.equals(Biomes.field_76781_i)) {
            this.tank.fillInternal(new FluidStack(FluidRegistry.WATER, 100), true);
        }
    }
}

