/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.helper.Logger;
import dalapo.factech.tileentity.TileEntityAreaMachine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityAerolyzer
extends TileEntityAreaMachine {
    List<PotionEffect> effects = new ArrayList<PotionEffect>();
    int tankAmount = 0;

    public TileEntityAerolyzer() {
        super("aerolyzer", 1, 2, 1, 8);
    }

    @Override
    public boolean canRun() {
        return super.canRun() && this.hasWork;
    }

    @Override
    public void getHasWork() {
        this.hasWork = this.getInput().func_77973_b() == Items.field_151068_bn || this.tankAmount > 0;
    }

    @Override
    public void onLoad() {
        super.onLoad();
    }

    @Override
    protected boolean performAction() {
        if (this.tankAmount-- <= 0 && this.getInput().func_77973_b().equals(Items.field_151068_bn)) {
            this.effects = PotionUtils.func_185189_a((ItemStack)this.getInput());
            if (this.effects.isEmpty()) {
                return false;
            }
            this.tankAmount += this.effects.get(0).func_76459_b() / 100;
            this.doOutput(new ItemStack(Items.field_151069_bo));
            this.getInput().func_190918_g(1);
        }
        Logger.info(this.effects);
        List creatures = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c).func_186662_g((double)this.getAdjustedRange()));
        for (EntityLivingBase elb : creatures) {
            for (PotionEffect effect : this.effects) {
                PotionEffect modified = new PotionEffect(effect.func_188419_a(), 200, effect.func_76458_c());
                elb.func_70690_d(modified);
            }
        }
        return true;
    }

    @Override
    public int getBaseOpTicks() {
        return 150;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList effectsList = new NBTTagList();
        for (PotionEffect pe : this.effects) {
            effectsList.func_74742_a((NBTBase)new NBTTagInt(Potion.func_188409_a((Potion)pe.func_188419_a())));
        }
        nbt.func_74782_a("effects", (NBTBase)effectsList);
        nbt.func_74768_a("charges", this.tankAmount);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("effects")) {
            NBTTagList effectsList = nbt.func_150295_c("effects", 3);
            for (int i = 0; i < effectsList.func_74745_c(); ++i) {
                this.effects.add(new PotionEffect(Potion.func_188412_a((int)effectsList.func_186858_c(i)), 200));
            }
        }
        if (nbt.func_74764_b("charges")) {
            this.tankAmount = nbt.func_74762_e("charges");
        }
    }
}

