/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.auxiliary.IMachineRecipe;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.tileentity.TileEntityFluidMachine;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityAgitator
extends TileEntityFluidMachine {
    private int activeRecipe = -1;

    public TileEntityAgitator() {
        super("agitator", 1, 3, 1, 3, 2);
    }

    @Override
    public boolean canRun() {
        return super.canRun() && this.activeRecipe != -1;
    }

    @Override
    public void getHasWork() {
        for (int r = 0; r < MachineRecipes.AGITATOR.size(); ++r) {
            boolean flag = true;
            if (!FacStackHelper.areItemsEqualAllowEmpty(this.getInput(), MachineRecipes.AGITATOR.get((int)r).input, true)) {
                flag = false;
            }
            for (int i = 0; i < 2; ++i) {
                if (this.getTank(MachineRecipes.AGITATOR.get(r).getInputFluid(i)) == -1) {
                    flag = false;
                    break;
                }
                FluidStack output = MachineRecipes.AGITATOR.get((int)r).fluidOut;
                if ((output == null || this.tanks[2].getFluid() == null || this.tanks[2].getFluid().isFluidEqual(output)) && (output == null || this.tanks[2].getFluidAmount() + output.amount <= 10000)) continue;
                flag = false;
            }
            if (!flag) continue;
            this.activeRecipe = r;
            this.hasWork = true;
            return;
        }
        this.activeRecipe = -1;
        this.hasWork = false;
    }

    private int getTank(FluidStack fluid) {
        if (fluid == null) {
            for (int i = 0; i < 2; ++i) {
                if (this.tanks[i].getFluid() != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                if (this.tanks[i].getFluid() == null || !this.tanks[i].getFluid().getFluid().equals(fluid.getFluid()) || this.tanks[i].getFluidAmount() < fluid.amount) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    protected boolean performAction() {
        FluidStack toFill;
        AgitatorRecipe recipe = MachineRecipes.AGITATOR.get(this.activeRecipe);
        for (int i = 0; i < 2; ++i) {
            int tank = this.getTank(recipe.getInputFluid(i));
            this.tanks[tank].drainInternal(recipe.getInputFluid(i) == null ? 0 : recipe.getInputFluid((int)i).amount, true);
        }
        this.getInput(0).func_190918_g(recipe.input.func_190916_E());
        this.doOutput(recipe.output.func_77946_l());
        FluidStack fluidStack = toFill = recipe.fluidOut == null ? null : recipe.fluidOut.copy();
        if (toFill != null) {
            this.tanks[2].fillInternal(recipe.fluidOut.copy(), true);
        }
        this.getHasWork();
        FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
        return true;
    }

    @Override
    public int getBaseOpTicks() {
        return 120;
    }

    @Override
    public void onTankUpdate() {
        this.getHasWork();
    }

    public static class AgitatorRecipe
    implements IMachineRecipe<ItemStack> {
        FluidStack fluidA;
        FluidStack fluidB;
        ItemStack input;
        ItemStack output;
        FluidStack fluidOut;

        public AgitatorRecipe(@Nullable ItemStack input, @Nullable ItemStack output, @Nullable FluidStack fluidOut, @Nonnull FluidStack fluidA, @Nullable FluidStack fluidB) {
            this.fluidA = fluidA;
            this.fluidB = fluidB;
            this.input = input != null ? input : ItemStack.field_190927_a;
            this.output = output != null ? output : ItemStack.field_190927_a;
            this.fluidOut = fluidOut;
        }

        public FluidStack getInputFluid(int slot) {
            if (slot == 1) {
                return this.fluidB;
            }
            return this.fluidA;
        }

        public ItemStack getInputItem() {
            return this.input;
        }

        public FluidStack getOutputFluid() {
            return this.fluidOut;
        }

        public ItemStack getOutputItem() {
            return this.output;
        }

        @Override
        public ItemStack getOutputStack() {
            return this.getOutputItem();
        }
    }
}

