/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.FactoryTech;
import dalapo.factech.config.FacTechConfigManager;
import dalapo.factech.init.ItemRegistry;
import dalapo.factech.tileentity.TileEntityAreaMachine;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileEntityAutoMiner
extends TileEntityAreaMachine {
    private BlockPos nextToMine;
    private int radius;
    private int range = 64;
    private int curDist = 1;
    private boolean isMining;

    public TileEntityAutoMiner() {
        super("miner", 0, 3, 9, 6);
    }

    public ItemStack getChunk(int yLevel) {
        int r = FactoryTech.random.nextInt(100);
        if (r == 0 && yLevel <= 12) {
            return new ItemStack(Items.field_151045_i);
        }
        if (r <= 34) {
            return new ItemStack((Item)ItemRegistry.minedOre, 1, 1);
        }
        return new ItemStack((Item)ItemRegistry.minedOre, 1, 0);
    }

    public int getDist() {
        return this.curDist;
    }

    private BlockPos findNextBlock() {
        for (int x = this.field_174879_c.func_177958_n() - this.getAdjustedRange(); x <= this.field_174879_c.func_177958_n() + this.getAdjustedRange(); ++x) {
            for (int z = this.field_174879_c.func_177952_p() - this.getAdjustedRange(); z <= this.field_174879_c.func_177952_p() + this.getAdjustedRange(); ++z) {
                BlockPos toBreak = new BlockPos(x, this.field_174879_c.func_177956_o() - this.curDist, z);
                Block target = this.field_145850_b.func_180495_p(toBreak).func_177230_c();
                if (target == Blocks.field_150350_a || target == Blocks.field_150355_j || target == Blocks.field_150358_i || target == Blocks.field_150357_h) continue;
                return toBreak;
            }
        }
        if (this.field_174879_c.func_177956_o() - this.curDist > 0 && this.curDist < this.range) {
            ++this.curDist;
            return this.findNextBlock();
        }
        return null;
    }

    @Override
    protected boolean performAction() {
        this.nextToMine = this.findNextBlock();
        if (this.nextToMine == null) {
            return false;
        }
        IBlockState stateAtDrop = this.field_145850_b.func_180495_p(this.nextToMine);
        NonNullList drops = NonNullList.func_191196_a();
        stateAtDrop.func_177230_c().getDrops(drops, (IBlockAccess)this.field_145850_b, this.nextToMine, stateAtDrop, 0);
        if (stateAtDrop.func_177230_c().equals(Blocks.field_150365_q)) {
            ((ItemStack)drops.get(0)).func_190917_f(1);
        }
        if (!stateAtDrop.func_177230_c().equals(Blocks.field_150357_h)) {
            this.field_145850_b.func_175698_g(this.nextToMine);
        }
        for (ItemStack is : drops) {
            EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, is);
            ei.field_70159_w = 0.0;
            ei.field_70179_y = 0.0;
            this.field_145850_b.func_72838_d((Entity)ei);
        }
        if (FactoryTech.random.nextDouble() < (double)FacTechConfigManager.quarryChunkChance) {
            ItemStack chunk = this.getChunk(this.nextToMine.func_177956_o());
            EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, chunk);
            ei.field_70159_w = 0.0;
            ei.field_70179_y = 0.0;
            this.field_145850_b.func_72838_d((Entity)ei);
        }
        return true;
    }

    @Override
    public int getBaseOpTicks() {
        return 20;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.nextToMine != null) {
            NBTTagList next = new NBTTagList();
            next.func_74742_a((NBTBase)new NBTTagInt(this.nextToMine.func_177958_n()));
            next.func_74742_a((NBTBase)new NBTTagInt(this.nextToMine.func_177956_o()));
            next.func_74742_a((NBTBase)new NBTTagInt(this.nextToMine.func_177952_p()));
            nbt.func_74782_a("nextBlock", (NBTBase)next);
        }
        nbt.func_74768_a("dist", this.curDist);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("nextBlock")) {
            NBTTagList next = nbt.func_150295_c("nextBlock", 3);
            this.nextToMine = new BlockPos(next.func_186858_c(0), next.func_186858_c(1), next.func_186858_c(2));
        }
        if (nbt.func_74764_b("dist")) {
            this.curDist = nbt.func_74762_e("dist");
        }
    }

    @Override
    public void getHasWork() {
        this.hasWork = true;
    }
}

