/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.FactoryTech;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacMiscHelper;
import dalapo.factech.init.ModFluidRegistry;
import dalapo.factech.reference.StateList;
import dalapo.factech.tileentity.IMagnifyingGlassInfo;
import dalapo.factech.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityBlowtorch
extends TileEntityBase
implements ITickable,
IMagnifyingGlassInfo {
    private static final double k = 0.0025;
    private FluidTank tank = new FluidTank(10000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && fluid.getFluid() == ModFluidRegistry.propane && this.canFill();
        }
    };
    private EnumFacing direction;
    private double temperature = 10.0;
    private boolean hasLoaded = false;
    private boolean isFiring = false;

    public TileEntityBlowtorch() {
        super("blowtorch");
        this.tank.setTileEntity((TileEntity)this);
    }

    private double adjustTemperature(double biomeTemp) {
        return 50.0 * biomeTemp - 7.5;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (!this.hasLoaded) {
            this.direction = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(StateList.directions);
            this.hasLoaded = true;
        }
        this.updateTemperature();
        if (this.isPowered() && this.tank.getFluidAmount() > 0 && this.tank.getFluid().getFluid() == ModFluidRegistry.propane) {
            this.isFiring = true;
            if (!this.field_145850_b.field_72995_K) {
                AxisAlignedBB attackBox = new AxisAlignedBB(FacMathHelper.withOffset(this.field_174879_c, this.direction));
                attackBox = attackBox.func_72321_a((double)(3 * this.direction.func_82601_c()), (double)(3 * this.direction.func_96559_d()), (double)(3 * this.direction.func_82599_e()));
                for (EntityLivingBase e : this.field_145850_b.func_72872_a(EntityLivingBase.class, attackBox)) {
                    e.func_70015_d(5);
                    e.func_70097_a(DamageSource.field_76372_a, 5.0f);
                }
                if (this.temperature > 500.0) {
                    for (EntityItem ei : this.field_145850_b.func_72872_a(EntityItem.class, attackBox)) {
                        ItemStack is = FurnaceRecipes.func_77602_a().func_151395_a(ei.func_92059_d()).func_77946_l();
                        if (is.func_190926_b() || FactoryTech.random.nextInt((int)(17000.0 / this.temperature)) != 0) continue;
                        EntityItem smelted = new EntityItem(this.field_145850_b, ei.field_70165_t, ei.field_70163_u, ei.field_70161_v, is);
                        smelted.field_70159_w = ei.field_70159_w;
                        smelted.field_70181_x = ei.field_70181_x;
                        smelted.field_70179_y = ei.field_70179_y;
                        this.field_145850_b.func_72838_d((Entity)smelted);
                        ei.func_92059_d().func_190918_g(1);
                        if (!ei.func_92059_d().func_190926_b()) continue;
                        ei.func_70106_y();
                    }
                    for (BlockPos bp : BlockPos.func_177980_a((BlockPos)this.field_174879_c, (BlockPos)FacMathHelper.withOffsetAndDist(this.field_174879_c, this.direction, 4))) {
                        IBlockState state = this.field_145850_b.func_180495_p(bp);
                        if (this.field_145850_b.func_175623_d(bp) || FactoryTech.random.nextInt(20) != 0) continue;
                        Block b = state.func_177230_c();
                        ItemStack is = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(b)).func_77946_l();
                        if (!is.func_190926_b()) {
                            if (is.func_77973_b() instanceof ItemBlock) {
                                IBlockState targetState = ((ItemBlock)is.func_77973_b()).func_179223_d().func_176203_a(is.func_77952_i());
                                this.field_145850_b.func_175656_a(bp, targetState);
                                continue;
                            }
                            this.field_145850_b.func_175698_g(bp);
                            EntityItem ei = new EntityItem(this.field_145850_b, (double)bp.func_177958_n() + 0.5, (double)bp.func_177956_o() + 0.5, (double)bp.func_177952_p() + 0.5, is);
                            this.field_145850_b.func_72838_d((Entity)ei);
                            continue;
                        }
                        if (!state.func_185904_a().func_76217_h() || FactoryTech.random.nextInt(20) != 0) continue;
                        this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)bp.func_177958_n() + 0.5, (double)bp.func_177956_o() + 0.5, (double)bp.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
                        this.field_145850_b.func_184133_a(null, bp, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        this.field_145850_b.func_175698_g(bp);
                    }
                }
            }
            Vec3d dirVec = new Vec3d(this.direction.func_176730_m()).func_186678_a(0.25);
            Vec3d vf = FacMathHelper.randomOffset(dirVec, 0.1, 0.1, 0.1);
            for (int i = 0; i < 5; ++i) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)this.direction.func_82601_c() / 2.0, (double)this.field_174879_c.func_177956_o() + 0.5 + (double)this.direction.func_96559_d() / 2.0, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)this.direction.func_82599_e() / 2.0, vf.field_72450_a, vf.field_72448_b, vf.field_72449_c, new int[0]);
            }
            if (this.temperature > 900.0 && FactoryTech.random.nextInt(3) == 0) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.LAVA, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
            }
            this.tank.drainInternal(3, true);
        } else {
            this.isFiring = false;
        }
    }

    private void updateTemperature() {
        double ambientTemp = this.isFiring ? 1000.0 : this.adjustTemperature(this.field_145850_b.func_180494_b(this.field_174879_c).func_180626_a(this.field_174879_c));
        this.temperature += (ambientTemp - this.temperature) * 0.0025;
        if (this.temperature > 900.0) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
            this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 4.0f, true);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.hasLoaded = false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.tank.writeToNBT(nbt);
        nbt.func_74780_a("temp", this.temperature);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt);
        this.temperature = nbt.func_74769_h("temp");
    }

    @Override
    public List<String> getGlassInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(FacMiscHelper.describeTank(this.tank));
        info.add(I18n.func_135052_a((String)"factorytech.temperature", (Object[])new Object[]{(int)this.temperature}));
        return info;
    }
}

