/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.auxiliary.IMachineRecipe;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.tileentity.TileEntityFluidMachine;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityCompressionChamber
extends TileEntityFluidMachine {
    private int activeRecipe = -1;

    public TileEntityCompressionChamber() {
        super("cchamber", 1, 2, 1, 1, 1);
    }

    private boolean validateFluidTank() {
        if (this.tanks[0].getFluid() == null) {
            return true;
        }
        Fluid fluid = this.tanks[0].getFluid().getFluid();
        return this.activeRecipe != 1 && this.tanks[0].getFluidAmount() >= ((CompressorRecipe)MachineRecipes.COMPRESSOR.get((int)this.activeRecipe)).fluidIn.amount;
    }

    @Override
    public boolean canRun() {
        return super.canRun() && this.activeRecipe != -1;
    }

    @Override
    public void getHasWork() {
        List<CompressorRecipe> recipes = MachineRecipes.COMPRESSOR;
        boolean recipeFound = false;
        for (int i = 0; i < recipes.size(); ++i) {
            CompressorRecipe cr = recipes.get(i);
            if ((cr.getFluidIn() == null || this.tanks[0].getFluid() == null ? cr.getFluidIn() == null != (this.tanks[0].getFluid() == null) : cr.getFluidIn().getFluid() != this.tanks[0].getFluid().getFluid() || cr.getFluidIn().amount > this.tanks[0].getFluidAmount()) || !cr.getItemIn().func_77969_a(this.getInput()) || !FacStackHelper.canCombineStacks(cr.getItemOut(), this.getOutput())) continue;
            recipeFound = true;
            this.activeRecipe = i;
            break;
        }
        if (this.getInput().func_190926_b() || !recipeFound) {
            this.activeRecipe = -1;
        }
        this.hasWork = this.activeRecipe != -1;
    }

    @Override
    protected boolean performAction() {
        CompressorRecipe cr = MachineRecipes.COMPRESSOR.get(this.activeRecipe);
        if (cr.getFluidIn() != null) {
            this.tanks[0].drainInternal(cr.getFluidIn().amount, true);
        }
        if (this.doOutput(cr.getItemOut())) {
            this.getInput().func_190918_g(cr.getItemIn().func_190916_E());
            this.getHasWork();
        }
        return true;
    }

    @Override
    public int getBaseOpTicks() {
        return 100;
    }

    public static class CompressorRecipe
    implements IMachineRecipe<ItemStack> {
        private FluidStack fluidIn;
        private ItemStack itemIn;
        private ItemStack itemOut;

        public CompressorRecipe(ItemStack itemIn, FluidStack fluidIn, ItemStack itemOut) {
            this.fluidIn = fluidIn;
            this.itemIn = itemIn;
            this.itemOut = itemOut;
        }

        public ItemStack getItemIn() {
            return this.itemIn.func_77946_l();
        }

        public ItemStack getItemOut() {
            return this.itemOut.func_77946_l();
        }

        @Override
        public ItemStack getOutputStack() {
            return this.getItemOut();
        }

        public FluidStack getFluidIn() {
            if (this.fluidIn == null) {
                return null;
            }
            return this.fluidIn.copy();
        }

        public String describe() {
            return String.format("Inputs: %s, %s; Output: %s", this.itemIn, this.fluidIn, this.itemOut);
        }
    }
}

